/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.fml.loading.modscan.Scanner;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import net.neoforged.neoforgespi.locating.ModFileInfoParser;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ModFile
implements IModFile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String jarVersion;
    private final ModFileInfoParser parser;
    private ModFileDiscoveryAttributes discoveryAttributes;
    private Map<String, Object> fileProperties;
    private List<IModLanguageLoader> loaders;
    private final SecureJar jar;
    private final IModFile.Type modFileType;
    private final Manifest manifest;
    private IModFileInfo modFileInfo;
    @Nullable
    private CompletableFuture<ModFileScanData> futureScanResult;
    private List<ModFileParser.MixinConfig> mixinConfigs;
    private List<Path> accessTransformers;
    public static final Attributes.Name TYPE = new Attributes.Name("FMLModType");

    public ModFile(SecureJar jar, ModFileInfoParser parser, ModFileDiscoveryAttributes attributes) {
        this(jar, parser, ModFile.parseType(jar), attributes);
    }

    public ModFile(SecureJar jar, ModFileInfoParser parser, IModFile.Type type, ModFileDiscoveryAttributes discoveryAttributes) {
        this.jar = Objects.requireNonNull(jar, "jar");
        this.parser = Objects.requireNonNull(parser, "parser");
        this.discoveryAttributes = Objects.requireNonNull(discoveryAttributes, "discoveryAttributes");
        this.manifest = this.jar.moduleDataProvider().getManifest();
        this.modFileType = Objects.requireNonNull(type, "type");
        this.jarVersion = Optional.ofNullable(this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION)).orElse("0.0NONE");
        this.modFileInfo = ModFileParser.readModList(this, this.parser);
    }

    @Override
    public Supplier<Map<String, Object>> getSubstitutionMap() {
        return () -> ImmutableMap.builder().put((Object)"jarVersion", (Object)this.jarVersion).putAll(this.fileProperties).build();
    }

    public List<IModLanguageLoader> getLoaders() {
        return this.loaders;
    }

    @Override
    public IModFile.Type getType() {
        return this.modFileType;
    }

    @Override
    public Path getFilePath() {
        return this.jar.getPrimaryPath();
    }

    @Override
    public SecureJar getSecureJar() {
        return this.jar;
    }

    @Override
    public List<IModInfo> getModInfos() {
        return this.modFileInfo.getMods();
    }

    public List<Path> getAccessTransformers() {
        return this.accessTransformers;
    }

    public boolean identifyMods() {
        this.modFileInfo = ModFileParser.readModList(this, this.parser);
        if (this.modFileInfo == null) {
            return this.getType() != IModFile.Type.MOD;
        }
        LOGGER.debug(LogMarkers.LOADING, "Loading mod file {} with languages {}", (Object)this.getFilePath(), this.modFileInfo.requiredLanguageLoaders());
        this.mixinConfigs = ModFileParser.getMixinConfigs(this.modFileInfo);
        this.mixinConfigs.forEach(mc -> LOGGER.debug(LogMarkers.LOADING, "Found mixin config {}", mc));
        this.accessTransformers = ModFileParser.getAccessTransformers(this.modFileInfo).map(list -> list.stream().map(xva$0 -> this.findResource((String)xva$0)).filter(path -> {
            if (Files.notExists(path, new LinkOption[0])) {
                LOGGER.error(LogMarkers.LOADING, "Access transformer file {} provided by mod {} does not exist!", path, (Object)this.modFileInfo.moduleName());
                return false;
            }
            return true;
        })).orElseGet(() -> Stream.of(this.findResource("META-INF", "accesstransformer.cfg")).filter(x$0 -> Files.exists(x$0, new LinkOption[0]))).toList();
        return true;
    }

    public List<ModFileParser.MixinConfig> getMixinConfigs() {
        return this.mixinConfigs;
    }

    public void scanFile(Consumer<Path> pathConsumer) {
        Path rootPath = this.getSecureJar().getRootPath();
        try (Stream<Path> files = Files.find(rootPath, Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            files.forEach(pathConsumer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to scan " + String.valueOf(rootPath), e);
        }
    }

    public CompletionStage<ModFileScanData> startScan(Executor executor) {
        if (this.futureScanResult != null) {
            throw new IllegalStateException("The mod file scan was already started.");
        }
        this.futureScanResult = CompletableFuture.supplyAsync(() -> new Scanner(this).scan(), executor);
        return this.futureScanResult;
    }

    @Override
    public ModFileScanData getScanResult() {
        if (this.futureScanResult == null) {
            throw new IllegalStateException("Scanning of this mod file has not started yet.");
        }
        try {
            return this.futureScanResult.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for mod file scan to complete.");
        }
    }

    public void setFileProperties(Map<String, Object> fileProperties) {
        this.fileProperties = fileProperties;
    }

    @Override
    public Path findResource(String ... path) {
        if (path.length < 1) {
            throw new IllegalArgumentException("Missing path");
        }
        return this.getSecureJar().getPath(String.join((CharSequence)"/", path), new String[0]);
    }

    public void identifyLanguage() {
        this.loaders = this.modFileInfo.requiredLanguageLoaders().stream().map(spec -> FMLLoader.getLanguageLoadingProvider().findLanguage(this, spec.languageName(), spec.acceptedVersions())).toList();
    }

    public String toString() {
        if (this.discoveryAttributes.parent() != null) {
            return "Nested Mod File " + String.valueOf(this.jar.getPrimaryPath()) + " in " + String.valueOf(this.discoveryAttributes.parent());
        }
        return "Mod File: " + String.valueOf(this.jar.getPrimaryPath());
    }

    @Override
    public String getFileName() {
        return this.getFilePath().getFileName().toString();
    }

    @Override
    public ModFileDiscoveryAttributes getDiscoveryAttributes() {
        return this.discoveryAttributes;
    }

    public void setDiscoveryAttributes(ModFileDiscoveryAttributes discoveryAttributes) {
        this.discoveryAttributes = discoveryAttributes;
    }

    @Override
    public IModFileInfo getModFileInfo() {
        return this.modFileInfo;
    }

    public ArtifactVersion getJarVersion() {
        return new DefaultArtifactVersion(this.jarVersion);
    }

    private static IModFile.Type parseType(SecureJar jar) {
        Manifest m = jar.moduleDataProvider().getManifest();
        Optional<String> value = Optional.ofNullable(m.getMainAttributes().getValue(TYPE));
        return value.map(IModFile.Type::valueOf).orElse(IModFile.Type.MOD);
    }
}

