/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.javafmlmod;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.EventBusErrorMessage;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.javafmlmod.AutomaticEventSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;

public class FMLModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker LOADING = MarkerManager.getMarker((String)"LOADING");
    private final ModFileScanData scanResults;
    private final IEventBus eventBus;
    private final List<Class<?>> modClasses;
    private final Module layer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FMLModContainer(IModInfo info, List<String> entrypoints, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
        super(info);
        LOGGER.debug(LOADING, "Creating FMLModContainer instance for {}", entrypoints);
        this.scanResults = modFileScanResults;
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).markerType(IModBusEvent.class).allowPerPhasePost().build();
        this.layer = gameLayer.findModule(info.getOwningFile().moduleName()).orElseThrow();
        ModLoadingContext context = ModLoadingContext.get();
        try {
            context.setActiveContainer(this);
            this.modClasses = new ArrayList();
            for (String entrypoint : entrypoints) {
                try {
                    Class<?> cls = Class.forName(this.layer, entrypoint);
                    this.modClasses.add(cls);
                    LOGGER.trace(LOADING, "Loaded modclass {} with {}", (Object)cls.getName(), (Object)cls.getClassLoader());
                }
                catch (Throwable e) {
                    LOGGER.error(LOADING, "Failed to load class {}", (Object)entrypoint, (Object)e);
                    throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.failedtoloadmodclass", new Object[0]).withCause(e).withAffectedMod(info));
                    return;
                }
            }
        }
        finally {
            context.setActiveContainer(null);
        }
    }

    private void onEventFailed(IEventBus iEventBus, Event event, EventListener[] iEventListeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, iEventListeners, throwable));
    }

    @Override
    protected void constructMod() {
        for (Class<?> modClass : this.modClasses) {
            try {
                Constructor<?>[] constructors = modClass.getConstructors();
                if (constructors.length != 1) {
                    throw new RuntimeException("Mod class " + String.valueOf(modClass) + " must have exactly 1 public constructor, found " + constructors.length);
                }
                Constructor<?> constructor = constructors[0];
                Map<Class<Dist>, Dist> allowedConstructorArgs = Map.of(IEventBus.class, this.eventBus, ModContainer.class, this, FMLModContainer.class, this, Dist.class, FMLLoader.getDist());
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                Object[] constructorArgs = new Object[parameterTypes.length];
                HashSet foundArgs = new HashSet();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Dist argInstance = allowedConstructorArgs.get(parameterTypes[i]);
                    if (argInstance == null) {
                        throw new RuntimeException("Mod constructor has unsupported argument " + String.valueOf(parameterTypes[i]) + ". Allowed optional argument classes: " + allowedConstructorArgs.keySet().stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
                    }
                    if (foundArgs.contains(parameterTypes[i])) {
                        throw new RuntimeException("Duplicate mod constructor argument type: " + String.valueOf(parameterTypes[i]));
                    }
                    foundArgs.add(parameterTypes[i]);
                    constructorArgs[i] = argInstance;
                }
                constructor.newInstance(constructorArgs);
                LOGGER.trace(LOADING, "Loaded mod instance {} of type {}", (Object)this.getModId(), (Object)modClass.getName());
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = e.getCause();
                }
                LOGGER.error(LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)modClass.getName(), (Object)e);
                throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.failedtoloadmod", new Object[0]).withCause(e).withAffectedMod(this.modInfo));
            }
        }
        try {
            LOGGER.trace(LOADING, "Injecting Automatic event subscribers for {}", (Object)this.getModId());
            AutomaticEventSubscriber.inject(this, this.scanResults, this.layer);
            LOGGER.trace(LOADING, "Completed Automatic event subscribers for {}", (Object)this.getModId());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to register automatic subscribers. ModID: {}", (Object)this.getModId(), (Object)e);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.failedtoloadmod", new Object[0]).withCause(e).withAffectedMod(this.modInfo));
        }
    }

    @Override
    public IEventBus getEventBus() {
        return this.eventBus;
    }
}

