/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.locating;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class ForgeFeature {
    private static final Map<String, IFeatureTest<?>> features = new HashMap();
    private static final MissingFeatureTest MISSING = new MissingFeatureTest();

    private ForgeFeature() {
    }

    public static <T> void registerFeature(String featureName, IFeatureTest<T> featureTest) {
        features.put(featureName, featureTest);
    }

    public static boolean testFeature(Dist side, Bound bound) {
        return ((IFeatureTest)features.getOrDefault(bound.featureName(), MISSING)).testSideWithString(side, bound.featureBound());
    }

    public static Object featureValue(Bound bound) {
        return ((IFeatureTest)features.getOrDefault(bound.featureName(), MISSING)).featureValue();
    }

    public record Bound(String featureName, String featureBound, IModInfo modInfo) {
        public <T> T bound() {
            return (T)((IFeatureTest)features.getOrDefault(this.featureName, MISSING)).convertFromString(this.featureBound);
        }
    }

    private record MissingFeatureTest() implements IFeatureTest<Object>
    {
        @Override
        public IModInfo.DependencySide applicableSides() {
            return IModInfo.DependencySide.BOTH;
        }

        @Override
        public String featureValue() {
            return "NONE";
        }

        @Override
        public boolean test(Object o) {
            return false;
        }

        @Override
        public Object convertFromString(String value) {
            return null;
        }
    }

    public static sealed interface IFeatureTest<F>
    extends Predicate<F>
    permits MissingFeatureTest, VersionFeatureTest, BooleanFeatureTest {
        public IModInfo.DependencySide applicableSides();

        public F convertFromString(String var1);

        public String featureValue();

        default public boolean testSideWithString(Dist side, String value) {
            return !this.applicableSides().isContained(side) || this.test(this.convertFromString(value));
        }
    }

    public record BooleanFeatureTest(IModInfo.DependencySide applicableSides, boolean value) implements IFeatureTest<Boolean>
    {
        @Override
        public boolean test(Boolean aBoolean) {
            return aBoolean.equals(this.value);
        }

        @Override
        public String featureValue() {
            return Boolean.toString(this.value);
        }

        @Override
        public Boolean convertFromString(String value) {
            return Boolean.parseBoolean(value);
        }
    }

    public record VersionFeatureTest(IModInfo.DependencySide applicableSides, ArtifactVersion version) implements IFeatureTest<VersionRange>
    {
        public static VersionFeatureTest forVersionString(IModInfo.DependencySide side, String version) {
            return new VersionFeatureTest(side, (ArtifactVersion)new DefaultArtifactVersion(version));
        }

        @Override
        public String featureValue() {
            return this.version.toString();
        }

        @Override
        public boolean test(VersionRange versionRange) {
            return versionRange.containsVersion(this.version);
        }

        @Override
        public VersionRange convertFromString(String value) {
            try {
                return VersionRange.createFromVersionSpec((String)value);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

