/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.ModSorter;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.modscan.BackgroundScanHandler;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ModValidator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<IModFile.Type, List<ModFile>> modFiles;
    private final List<ModFile> candidatePlugins;
    private final List<ModFile> candidateMods;
    private final List<ModLoadingIssue> issues;
    private LoadingModList loadingModList;

    public ModValidator(Map<IModFile.Type, List<ModFile>> modFiles, List<ModLoadingIssue> issues) {
        this.modFiles = modFiles;
        this.candidateMods = ModValidator.lst(modFiles.get((Object)IModFile.Type.MOD));
        this.candidateMods.addAll(ModValidator.lst(modFiles.get((Object)IModFile.Type.GAMELIBRARY)));
        this.candidatePlugins = ModValidator.lst(modFiles.get((Object)IModFile.Type.LIBRARY));
        this.issues = issues;
    }

    private static List<ModFile> lst(@Nullable List<ModFile> files) {
        return files == null ? new ArrayList<ModFile>() : new ArrayList<ModFile>(files);
    }

    public void stage1Validation() {
        this.validateFiles(this.candidateMods);
        if (LOGGER.isDebugEnabled(LogMarkers.SCAN)) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod files with {} mods", (Object)this.candidateMods.size(), (Object)this.candidateMods.stream().mapToInt(mf -> mf.getModInfos().size()).sum());
        }
        ImmediateWindowHandler.updateProgress("Found " + this.candidateMods.size() + " mod candidates");
    }

    private void validateFiles(List<ModFile> mods) {
        Iterator<ModFile> iterator = mods.iterator();
        while (iterator.hasNext()) {
            ModFile modFile = iterator.next();
            if (modFile.identifyMods()) continue;
            LOGGER.warn(LogMarkers.SCAN, "File {} has been ignored - it is invalid", (Object)modFile.getFilePath());
            iterator.remove();
        }
    }

    public ITransformationService.Resource getPluginResources() {
        return new ITransformationService.Resource(IModuleLayerManager.Layer.PLUGIN, this.candidatePlugins.stream().map(IModFile::getSecureJar).toList());
    }

    public ITransformationService.Resource getModResources() {
        Stream<ModFile> modFilesToLoad = Stream.concat(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile), ModValidator.lst(this.modFiles.get((Object)IModFile.Type.GAMELIBRARY)).stream());
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, modFilesToLoad.map(ModFile::getSecureJar).toList());
    }

    private void validateLanguages() {
        Iterator<ModFile> iterator = this.candidateMods.iterator();
        while (iterator.hasNext()) {
            ModFile modFile = iterator.next();
            try {
                modFile.identifyLanguage();
            }
            catch (ModLoadingException e) {
                this.issues.addAll(e.getIssues());
                iterator.remove();
            }
            catch (Exception e) {
                this.issues.add(ModLoadingIssue.error("fml.modloading.technical_error", new Object[0]).withAffectedModFile(modFile).withCause(e));
                iterator.remove();
            }
        }
    }

    public BackgroundScanHandler stage2Validation() {
        this.validateLanguages();
        this.loadingModList = ModSorter.sort(this.candidatePlugins, this.candidateMods, this.issues);
        this.loadingModList.addAccessTransformers();
        this.loadingModList.addMixinConfigs();
        BackgroundScanHandler backgroundScanHandler = new BackgroundScanHandler();
        this.loadingModList.addForScanning(backgroundScanHandler);
        return backgroundScanHandler;
    }
}

