/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import net.neoforged.fml.loading.LogMarkers;
import org.slf4j.Logger;

public enum FMLPaths {
    GAMEDIR,
    MODSDIR("mods"),
    CONFIGDIR("config"),
    FMLCONFIG(false, CONFIGDIR, "fml.toml");

    private static final Logger LOGGER;
    private final Path relativePath;
    private final boolean isDirectory;
    private Path absolutePath;

    private FMLPaths() {
        this("");
    }

    private FMLPaths(String ... path) {
        this.relativePath = this.computePath(path);
        this.isDirectory = true;
    }

    private FMLPaths(boolean isDir, FMLPaths parent, String ... path) {
        this.relativePath = parent.relativePath.resolve(this.computePath(path));
        this.isDirectory = isDir;
    }

    private Path computePath(String ... path) {
        return Paths.get(path[0], Arrays.copyOfRange(path, 1, path.length));
    }

    public static void setup(IEnvironment env) {
        Path rootPath = (Path)env.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElseThrow(() -> new RuntimeException("No game path found"));
        FMLPaths.loadAbsolutePaths(rootPath);
    }

    public static void loadAbsolutePaths(Path rootPath) {
        for (FMLPaths path : FMLPaths.values()) {
            path.absolutePath = rootPath.resolve(path.relativePath).toAbsolutePath().normalize();
            if (path.isDirectory && !Files.isDirectory(path.absolutePath, new LinkOption[0])) {
                try {
                    Files.createDirectories(path.absolutePath, new FileAttribute[0]);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            if (!LOGGER.isDebugEnabled(LogMarkers.CORE)) continue;
            LOGGER.debug(LogMarkers.CORE, "Path {} is {}", (Object)path, (Object)path.absolutePath);
        }
    }

    public static Path getOrCreateGameRelativePath(Path path) {
        Path gameFolderPath = GAMEDIR.get().resolve(path);
        if (!Files.isDirectory(gameFolderPath, new LinkOption[0])) {
            try {
                Files.createDirectories(gameFolderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return gameFolderPath;
    }

    public Path relative() {
        return this.relativePath;
    }

    public Path get() {
        return this.absolutePath;
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

