/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.i18n;

import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.neoforgespi.locating.ForgeFeature;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;

public class MavenVersionTranslator {
    public static String artifactVersionToString(ArtifactVersion artifactVersion) {
        return artifactVersion.toString();
    }

    public static String versionRangeToString(VersionRange range) {
        return range.getRestrictions().stream().map(MavenVersionTranslator::restrictionToString).collect(Collectors.joining(", "));
    }

    public static String restrictionToString(Restriction restriction) {
        if (restriction.getLowerBound() == null && restriction.getUpperBound() == null) {
            return FMLTranslations.parseMessage("fml.messages.version.restriction.any", new Object[0]);
        }
        if (restriction.getLowerBound() != null && restriction.getUpperBound() != null) {
            if (Objects.equals(MavenVersionTranslator.artifactVersionToString(restriction.getLowerBound()), MavenVersionTranslator.artifactVersionToString(restriction.getUpperBound()))) {
                return MavenVersionTranslator.artifactVersionToString(restriction.getLowerBound());
            }
            if (restriction.isLowerBoundInclusive() && restriction.isUpperBoundInclusive()) {
                return FMLTranslations.parseMessage("fml.messages.version.restriction.bounded.inclusive", restriction.getLowerBound(), restriction.getUpperBound());
            }
            if (restriction.isLowerBoundInclusive()) {
                return FMLTranslations.parseMessage("fml.messages.version.restriction.bounded.upperexclusive", restriction.getLowerBound(), restriction.getUpperBound());
            }
            if (restriction.isUpperBoundInclusive()) {
                return FMLTranslations.parseMessage("fml.messages.version.restriction.bounded.lowerexclusive", restriction.getLowerBound(), restriction.getUpperBound());
            }
            return FMLTranslations.parseMessage("fml.messages.version.restriction.bounded.exclusive", restriction.getLowerBound(), restriction.getUpperBound());
        }
        if (restriction.getLowerBound() != null) {
            if (restriction.isLowerBoundInclusive()) {
                return FMLTranslations.parseMessage("fml.messages.version.restriction.lower.inclusive", restriction.getLowerBound());
            }
            return FMLTranslations.parseMessage("fml.messages.version.restriction.lower.exclusive", restriction.getLowerBound());
        }
        if (restriction.isUpperBoundInclusive()) {
            return FMLTranslations.parseMessage("fml.messages.version.restriction.upper.inclusive", restriction.getUpperBound());
        }
        return FMLTranslations.parseMessage("fml.messages.version.restriction.upper.exclusive", restriction.getUpperBound());
    }

    public static void parseVersionRange(StringBuffer stringBuffer, Object range) {
        stringBuffer.append(MavenVersionTranslator.versionRangeToString((VersionRange)range));
    }

    public static void parseFeatureBoundValue(StringBuffer stringBuffer, Object range) {
        if (range instanceof ForgeFeature.Bound) {
            ForgeFeature.Bound bound = (ForgeFeature.Bound)range;
            stringBuffer.append(bound.featureName());
            Object t = bound.bound();
            if (t instanceof Boolean) {
                Boolean b = (Boolean)t;
                stringBuffer.append("=").append(b);
            } else {
                t = bound.bound();
                if (t instanceof VersionRange) {
                    VersionRange vr = (VersionRange)t;
                    stringBuffer.append(" ").append(MavenVersionTranslator.versionRangeToString(vr));
                } else {
                    stringBuffer.append("=\"").append(bound.featureBound()).append("\"");
                }
            }
        }
    }
}

