/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.i18n;

import com.google.common.base.CharMatcher;
import java.nio.file.Path;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.i18n.I18nManager;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FMLTranslations {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ALLOWED_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private static final CharMatcher DISALLOWED_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000").negate();
    private static final Map<String, FormatFactory> CUSTOM_FACTORIES;
    private static final Pattern PATTERN_CONTROL_CODE;
    private static final Pattern FORMAT_PATTERN;

    private static void parseException(String formatString, StringBuffer stringBuffer, Object objectToParse) {
        Throwable t = (Throwable)objectToParse;
        if (Objects.equals(formatString, "msg")) {
            stringBuffer.append(t.getClass().getName()).append(": ").append(t.getMessage());
        } else if (Objects.equals(formatString, "cls")) {
            stringBuffer.append(t.getClass().getName());
        }
    }

    private static void parseModInfo(String formatString, StringBuffer stringBuffer, Object modInfo) {
        IModInfo info = (IModInfo)modInfo;
        if (Objects.equals(formatString, "id")) {
            stringBuffer.append(info.getModId());
        } else if (Objects.equals(formatString, "name")) {
            stringBuffer.append(info.getDisplayName());
        }
    }

    public static String getPattern(String patternName, Supplier<String> fallback) {
        String translated = I18nManager.currentLocale.get(patternName);
        return translated == null ? fallback.get() : translated;
    }

    public static String parseMessage(String i18nMessage, Object ... args) {
        return FMLTranslations.parseMessageWithFallback(i18nMessage, () -> i18nMessage, args);
    }

    public static String parseMessageWithFallback(String i18nMessage, Supplier<String> fallback, Object ... args) {
        String pattern = FMLTranslations.getPattern(i18nMessage, fallback);
        try {
            return FMLTranslations.parseFormat(pattern, args);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(Logging.CORE, "Illegal format found `{}`", (Object)pattern);
            return pattern;
        }
    }

    public static String parseEnglishMessage(String i18n, Object ... args) {
        String translated = I18nManager.DEFAULT_TRANSLATIONS.getOrDefault(i18n, i18n);
        try {
            return FMLTranslations.parseFormat(translated, args);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(Logging.CORE, "Illegal format found `{}`", (Object)translated);
            return translated;
        }
    }

    public static String parseFormat(String format, Object ... args) {
        AtomicInteger i = new AtomicInteger();
        format = FORMAT_PATTERN.matcher(format).replaceAll(matchResult -> {
            if (matchResult.group(0).equals("%%")) {
                return "%";
            }
            String groupIdx = matchResult.group(1);
            int index = groupIdx != null ? Integer.parseInt(groupIdx) - 1 : i.getAndIncrement();
            return "{" + index + "}";
        });
        ExtendedMessageFormat extendedMessageFormat = new ExtendedMessageFormat(format, CUSTOM_FACTORIES);
        return extendedMessageFormat.format((Object)args);
    }

    public static String translateIssueEnglish(ModLoadingIssue issue) {
        Object[] args = FMLTranslations.getTranslationArgs(issue);
        return FMLTranslations.parseEnglishMessage(issue.translationKey(), args);
    }

    public static String translateIssue(ModLoadingIssue issue) {
        Object[] args = FMLTranslations.getTranslationArgs(issue);
        return FMLTranslations.parseMessage(issue.translationKey(), args);
    }

    private static Object[] getTranslationArgs(ModLoadingIssue issue) {
        ArrayList<Object> args = new ArrayList<Object>(3 + issue.translationArgs().size());
        IModInfo modInfo = issue.affectedMod();
        IModFile file = issue.affectedModFile();
        while (modInfo == null && file != null) {
            if (!file.getModInfos().isEmpty()) {
                modInfo = file.getModInfos().getFirst();
            }
            file = file.getDiscoveryAttributes().parent();
        }
        args.add(modInfo);
        args.add(null);
        if (issue.severity() == ModLoadingIssue.Severity.ERROR) {
            args.add(issue.cause());
        }
        args.addAll(issue.translationArgs());
        args.replaceAll(FMLTranslations::formatArg);
        return args.toArray(Object[]::new);
    }

    private static Object formatArg(Object arg) {
        if (arg instanceof Path) {
            Path path = (Path)arg;
            Path gameDir = FMLLoader.getGamePath();
            if (gameDir != null && path.startsWith(gameDir)) {
                return gameDir.relativize(path).toString();
            }
            return path.toString();
        }
        return arg;
    }

    public static String stripControlCodes(String text) {
        return PATTERN_CONTROL_CODE.matcher(text).replaceAll("");
    }

    static {
        PATTERN_CONTROL_CODE = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
        FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
        CUSTOM_FACTORIES = new HashMap<String, FormatFactory>();
        CUSTOM_FACTORIES.put("modinfo", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> FMLTranslations.parseModInfo(formatString, stringBuffer, objectToParse)));
        CUSTOM_FACTORIES.put("lower", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> stringBuffer.append(StringUtils.toLowerCase(String.valueOf(objectToParse)))));
        CUSTOM_FACTORIES.put("upper", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> stringBuffer.append(StringUtils.toUpperCase(String.valueOf(objectToParse)))));
        CUSTOM_FACTORIES.put("exc", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> FMLTranslations.parseException(formatString, stringBuffer, objectToParse)));
        CUSTOM_FACTORIES.put("vr", (name, formatString, locale) -> new CustomReadOnlyFormat(MavenVersionTranslator::parseVersionRange));
        CUSTOM_FACTORIES.put("featurebound", (name, formatString, locale) -> new CustomReadOnlyFormat(MavenVersionTranslator::parseFeatureBoundValue));
        CUSTOM_FACTORIES.put("i18n", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> stringBuffer.append(FMLTranslations.parseMessage(formatString, o))));
        CUSTOM_FACTORIES.put("i18ntranslate", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> stringBuffer.append(FMLTranslations.parseMessage((String)o, new Object[0]))));
        CUSTOM_FACTORIES.put("ornull", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> stringBuffer.append(Objects.equals(String.valueOf(o), "null") ? FMLTranslations.parseMessage(formatString, new Object[0]) : String.valueOf(o))));
        CUSTOM_FACTORIES.put("optional", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> ((Optional)o).ifPresent(val -> stringBuffer.append(formatString == null ? "" : formatString).append(val))));
    }

    public static class CustomReadOnlyFormat
    extends Format {
        private final BiConsumer<StringBuffer, Object> formatter;

        CustomReadOnlyFormat(BiConsumer<StringBuffer, Object> formatter) {
            this.formatter = formatter;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            this.formatter.accept(toAppendTo, obj);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("Parsing is not supported");
        }
    }
}

