/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import java.util.function.Function;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.Bindings;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public interface IConfigEvent {
    public static final ConfigConfig CONFIGCONFIG = Bindings.getConfigConfiguration();

    public static IConfigEvent reloading(ModConfig modConfig) {
        return CONFIGCONFIG.reloading().apply(modConfig);
    }

    public static IConfigEvent loading(ModConfig modConfig) {
        return CONFIGCONFIG.loading().apply(modConfig);
    }

    @Nullable
    public static IConfigEvent unloading(ModConfig modConfig) {
        return CONFIGCONFIG.unloading() == null ? null : CONFIGCONFIG.unloading().apply(modConfig);
    }

    public ModConfig getConfig();

    default public void post() {
        IEventBus bus = this.getConfig().container.getEventBus();
        if (bus != null) {
            bus.post(this.self());
        }
    }

    default public <T extends Event> T self() {
        return (T)((Event)this);
    }

    public record ConfigConfig(Function<ModConfig, IConfigEvent> loading, Function<ModConfig, IConfigEvent> reloading, @Nullable Function<ModConfig, IConfigEvent> unloading) {
    }
}

