/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.util;

import com.google.common.collect.Streams;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.stream.Stream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IOrderedProvider;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ServiceLoaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderUtil.class);

    private ServiceLoaderUtil() {
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass) {
        return ServiceLoaderUtil.loadServices(context, serviceClass, List.of());
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass, Collection<T> additionalServices) {
        Stream<Object> serviceLoaderServices = context.loadServices(serviceClass).map(p -> {
            try {
                return p.get();
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.error("Failed to load implementation for {}", (Object)serviceClass, (Object)sce);
                return null;
            }
        }).filter(Objects::nonNull);
        Stream<Object> servicesStream = Streams.concat((Stream[])new Stream[]{additionalServices.stream(), serviceLoaderServices}).distinct();
        boolean applyPriority = IOrderedProvider.class.isAssignableFrom(serviceClass);
        if (applyPriority) {
            servicesStream = servicesStream.sorted(Comparator.comparingInt(service -> ((IOrderedProvider)service).getPriority()).reversed());
        }
        List services = servicesStream.toList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogMarkers.CORE, "Found {} implementations of {}:", (Object)services.size(), (Object)serviceClass.getSimpleName());
            for (Object service2 : services) {
                String priorityPrefix = "";
                if (applyPriority) {
                    priorityPrefix = String.format(Locale.ROOT, "%8d - ", ((IOrderedProvider)service2).getPriority());
                }
                if (additionalServices.contains(service2)) {
                    LOGGER.debug(LogMarkers.CORE, "\t{}[built-in] {}", (Object)priorityPrefix, (Object)ServiceLoaderUtil.identifyService(service2));
                    continue;
                }
                LOGGER.debug(LogMarkers.CORE, "\t{}{}", (Object)priorityPrefix, (Object)ServiceLoaderUtil.identifyService(service2));
            }
        }
        return services;
    }

    private static String identifyService(Object o) {
        String sourceFile;
        try {
            Path sourcePath = Paths.get(o.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            sourceFile = Files.isDirectory(sourcePath, new LinkOption[0]) ? sourcePath.toAbsolutePath().toString() : sourcePath.getFileName().toString();
        }
        catch (URISyntaxException e) {
            sourceFile = "<unknown>";
        }
        return o.getClass().getName() + " from " + sourceFile;
    }
}

