/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.loading.moddiscovery.AbstractJarFileModLocator;

public class BuiltinGameLibraryLocator
extends AbstractJarFileModLocator {
    private final List<Path> legacyClasspath = AbstractJarFileModLocator.getLegacyClasspath();

    public String name() {
        return "builtin game layer libraries";
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    @Override
    public Stream<Path> scanCandidates() {
        String gameLibrariesStr = System.getProperty("fml.gameLayerLibraries");
        if (gameLibrariesStr == null || gameLibrariesStr.isBlank()) {
            return Stream.of(new Path[0]);
        }
        Set targets = Arrays.stream(gameLibrariesStr.split(",")).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toSet());
        Stream.Builder<Path> paths = Stream.builder();
        for (Path path : this.legacyClasspath) {
            if (!targets.contains(path.getFileName())) continue;
            paths.add(path);
        }
        return paths.build();
    }
}

