/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModLocator;
import net.neoforged.neoforgespi.locating.IModProvider;
import net.neoforged.neoforgespi.locating.ModFileLoadingException;
import org.slf4j.Logger;

public abstract class AbstractModProvider
implements IModProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";

    protected IModLocator.ModFileOrException createMod(Path ... path) {
        ModFile mod;
        JarContents jarContents = new JarContentsBuilder().paths(path).build();
        String type = jarContents.getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (type == null) {
            type = this.getDefaultJarModType();
        }
        if (jarContents.findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MODS_TOML, type, path});
            ModJarMetadata mjm = new ModJarMetadata(jarContents);
            mod = new ModFile(SecureJar.from((JarContents)jarContents, (JarMetadata)mjm), this, ModFileParser::modsTomlParser);
            mjm.setModFile(mod);
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MANIFEST, type, path});
            mod = new ModFile(SecureJar.from((JarContents)jarContents), this, this::manifestParser, type);
        } else {
            return new IModLocator.ModFileOrException(null, new ModFileLoadingException("Invalid mod file found " + Arrays.toString(path)));
        }
        return new IModLocator.ModFileOrException((IModFile)mod, null);
    }

    protected IModFileInfo manifestParser(IModFile mod) {
        Function<String, Optional> cfg = name -> Optional.ofNullable(mod.getSecureJar().moduleDataProvider().getManifest().getMainAttributes().getValue((String)name));
        String license = cfg.apply("LICENSE").orElse("");
        IConfigurable dummy = new IConfigurable(){

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new DefaultModFileInfo(mod, license, dummy);
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    protected String getDefaultJarModType() {
        return null;
    }

    private record DefaultModFileInfo(IModFile mod, String license, IConfigurable configurable) implements IModFileInfo,
    IConfigurable
    {
        public <T> Optional<T> getConfigElement(String ... strings) {
            return Optional.empty();
        }

        public List<? extends IConfigurable> getConfigList(String ... strings) {
            return null;
        }

        public List<IModInfo> getMods() {
            return Collections.emptyList();
        }

        public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
            return Collections.emptyList();
        }

        public boolean showAsResourcePack() {
            return false;
        }

        public boolean showAsDataPack() {
            return false;
        }

        public Map<String, Object> getFileProperties() {
            return Collections.emptyMap();
        }

        public String getLicense() {
            return this.license;
        }

        public IModFile getFile() {
            return this.mod;
        }

        public IConfigurable getConfig() {
            return this.configurable;
        }

        public String moduleName() {
            return this.mod.getSecureJar().name();
        }

        public String versionString() {
            return null;
        }

        public List<String> usesServices() {
            return null;
        }

        @Override
        public String toString() {
            return "IModFileInfo(" + this.mod.getFilePath() + ")";
        }
    }
}

