/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import net.neoforged.fml.loading.LogMarkers;
import org.slf4j.Logger;

public class ModJarURLHandler
extends URLStreamHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected URLConnection openConnection(URL url) {
        return new ModJarURLConnection(url);
    }

    @Override
    protected int hashCode(URL u) {
        return Objects.hash(u.getHost(), u.getFile());
    }

    @Override
    protected boolean equals(URL u1, URL u2) {
        return Objects.equals(u1.getProtocol(), u2.getProtocol()) && Objects.equals(u1.getHost(), u2.getHost()) && Objects.equals(u1.getFile(), u2.getFile());
    }

    static class ModJarURLConnection
    extends URLConnection {
        private Path resource;
        private String modpath;
        private String modid;
        private Optional<Manifest> manifest;

        public ModJarURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            LOGGER.trace(LogMarkers.CORE, "Loading modjar URL {} got resource {} {}", new Object[]{this.url, this.resource, this.resource != null ? Boolean.valueOf(Files.exists(this.resource, new LinkOption[0])) : "missing"});
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }

        @Override
        public long getContentLengthLong() {
            try {
                this.connect();
                return Files.size(this.resource);
            }
            catch (IOException e) {
                return -1L;
            }
        }

        @Override
        public URL getURL() {
            return (URL)LamdbaExceptionUtils.uncheck(() -> new URL("modjar://" + this.modid));
        }

        public Optional<Manifest> getManifest() {
            return this.manifest;
        }
    }
}

