/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.javafmlmod;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.fml.Logging;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageProvider;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class FMLJavaModLanguageProvider
implements IModLanguageProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Type MODANNOTATION = Type.getType((String)"Lnet/neoforged/fml/common/Mod;");

    public String name() {
        return "javafml";
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        return scanResult -> {
            Map modTargetMap = scanResult.getAnnotations().stream().filter(ad -> ad.annotationType().equals((Object)MODANNOTATION)).peek(ad -> LOGGER.debug(Logging.SCAN, "Found @Mod class {} with id {}", (Object)ad.clazz().getClassName(), ad.annotationData().get("value"))).map(ad -> new FMLModTarget(ad.clazz().getClassName(), (String)ad.annotationData().get("value"))).collect(Collectors.toMap(FMLModTarget::getModId, Function.identity(), (a, b) -> a));
            scanResult.addLanguageLoader(modTargetMap);
        };
    }

    private static class FMLModTarget
    implements IModLanguageProvider.IModLanguageLoader {
        private static final Logger LOGGER = LOGGER;
        private final String className;
        private final String modId;

        private FMLModTarget(String className, String modId) {
            this.className = className;
            this.modId = modId;
        }

        public String getModId() {
            return this.modId;
        }

        public <T> T loadMod(IModInfo info, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
            return (T)new FMLModContainer(info, this.className, modFileScanResults, gameLayer);
        }
    }
}

