/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class ConfigFileTypeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigFileTypeHandler TOML = new ConfigFileTypeHandler();
    private static final Path defaultConfigPath = FMLPaths.GAMEDIR.get().resolve(FMLConfig.getConfigValue(FMLConfig.ConfigValue.DEFAULT_CONFIG_PATH));

    public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
        return c -> {
            Path configPath = configBasePath.resolve(c.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> this.setupConfigFile((ModConfig)c, newfile, (ConfigFormat<?>)configFormat)).writingMode(WritingMode.REPLACE).build();
            LOGGER.debug(ConfigTracker.CONFIG, "Built TOML config for {}", (Object)configPath);
            try {
                configData.load();
            }
            catch (ParsingException ex) {
                LOGGER.warn(ConfigTracker.CONFIG, "Attempting to recreate {}", (Object)configPath);
                try {
                    ConfigFileTypeHandler.backUpConfig(configData.getNioPath(), 5);
                    Files.delete(configData.getNioPath());
                    configData.load();
                }
                catch (Throwable t) {
                    ex.addSuppressed(t);
                    throw new ConfigLoadingException((ModConfig)c, (Exception)((Object)ex));
                }
            }
            LOGGER.debug(ConfigTracker.CONFIG, "Loaded TOML config file {}", (Object)configPath);
            if (!FMLConfig.getBoolConfigValue(FMLConfig.ConfigValue.DISABLE_CONFIG_WATCHER)) {
                try {
                    FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((ModConfig)c, configData, Thread.currentThread().getContextClassLoader()));
                    LOGGER.debug(ConfigTracker.CONFIG, "Watching TOML config file {} for changes", (Object)configPath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't watch config file", e);
                }
            }
            return configData;
        };
    }

    public void unload(ModConfig config) {
        if (FMLConfig.getBoolConfigValue(FMLConfig.ConfigValue.DISABLE_CONFIG_WATCHER)) {
            return;
        }
        Path configPath = config.getFullPath();
        try {
            FileWatcher.defaultInstance().removeWatch(configPath);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath, (Object)e);
        }
    }

    private boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = defaultConfigPath.resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            LOGGER.info(ConfigTracker.CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig) {
        ConfigFileTypeHandler.backUpConfig(commentedFileConfig, 5);
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig, int maxBackups) {
        ConfigFileTypeHandler.backUpConfig(commentedFileConfig.getNioPath(), maxBackups);
    }

    public static void backUpConfig(Path commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFileName().toString());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFileName().toString()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig, bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            LOGGER.warn(ConfigTracker.CONFIG, "Failed to back up config file {}", (Object)commentedFileConfig, (Object)exception);
        }
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }

    private static class ConfigWatcher
    implements Runnable {
        private final ModConfig modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;

        ConfigWatcher(ModConfig modConfig, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = modConfig;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect((CommentedConfig)this.commentedFileConfig)) {
                        LOGGER.warn(ConfigTracker.CONFIG, "Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ConfigFileTypeHandler.backUpConfig(this.commentedFileConfig);
                        this.modConfig.getSpec().correct((CommentedConfig)this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException ex) {
                    throw new ConfigLoadingException(this.modConfig, (Exception)((Object)ex));
                }
                LOGGER.debug(ConfigTracker.CONFIG, "Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                IConfigEvent.reloading(this.modConfig).post();
            }
        }
    }
}

