/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.fml.Bindings;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.loading.EarlyLoadingException;
import net.neoforged.neoforgespi.language.IModInfo;

public class ModLoadingWarning {
    private final IModInfo modInfo;
    private final ModLoadingStage warningStage;
    private final String i18nMessage;
    private final List<Object> context;

    public ModLoadingWarning(IModInfo modInfo, ModLoadingStage warningStage, String i18nMessage, Object ... context) {
        this.modInfo = modInfo;
        this.warningStage = warningStage;
        this.i18nMessage = i18nMessage;
        this.context = Arrays.asList(context);
    }

    public String formatToString() {
        return Bindings.getMessageParser().get().parseMessage(this.i18nMessage, Streams.concat((Stream[])new Stream[]{Stream.of(new Object[]{this.modInfo, this.warningStage}), this.context.stream()}).toArray());
    }

    static Stream<ModLoadingWarning> fromEarlyException(EarlyLoadingException e) {
        return e.getAllData().stream().map(ed -> new ModLoadingWarning(ed.getModInfo(), ModLoadingStage.VALIDATE, ed.getI18message(), ed.getArgs()));
    }
}

