/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.IModStateTransition;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modId;
    protected final String namespace;
    protected final IModInfo modInfo;
    protected ModLoadingStage modLoadingStage;
    protected Supplier<?> contextExtension;
    protected final Map<ModLoadingStage, Runnable> activityMap = new HashMap<ModLoadingStage, Runnable>();
    protected final Map<Class<? extends IExtensionPoint<?>>, Supplier<?>> extensionPoints = new IdentityHashMap();
    protected final EnumMap<ModConfig.Type, ModConfig> configs = new EnumMap(ModConfig.Type.class);

    public ModContainer(IModInfo info) {
        String displayTestString;
        this.namespace = this.modId = info.getModId();
        this.modInfo = info;
        this.modLoadingStage = ModLoadingStage.CONSTRUCT;
        Supplier<IExtensionPoint.DisplayTest> displayTestSupplier = switch (displayTestString = info.getConfig().getConfigElement(new String[]{"displayTest"}).orElse("MATCH_VERSION")) {
            case "MATCH_VERSION" -> () -> new IExtensionPoint.DisplayTest(() -> this.modInfo.getVersion().toString(), (incoming, isNetwork) -> Objects.equals(incoming, this.modInfo.getVersion().toString()));
            case "IGNORE_SERVER_VERSION" -> () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (incoming, isNetwork) -> true);
            case "IGNORE_ALL_VERSION" -> () -> new IExtensionPoint.DisplayTest(() -> "", (incoming, isNetwork) -> true);
            case "NONE" -> null;
            default -> throw new IllegalArgumentException("Invalid displayTest value supplied in mods.toml");
        };
        if (displayTestSupplier != null) {
            this.registerExtensionPoint(IExtensionPoint.DisplayTest.class, displayTestSupplier);
        } else {
            this.extensionPoints.remove(IExtensionPoint.DisplayTest.class);
        }
    }

    ModContainer() {
        this.modLoadingStage = ModLoadingStage.ERROR;
        this.modId = "BROKEN";
        this.namespace = "BROKEN";
        this.modInfo = null;
    }

    public final String getModId() {
        return this.modId;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public ModLoadingStage getCurrentState() {
        return this.modLoadingStage;
    }

    public static <T extends Event> CompletableFuture<Void> buildTransitionHandler(ModContainer target, IModStateTransition.EventGenerator<T> eventGenerator, ProgressMeter progressBar, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> stateChangeHandler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ModLoadingContext.get().setActiveContainer(target);
            target.activityMap.getOrDefault((Object)target.modLoadingStage, () -> {}).run();
            target.acceptEvent((Event)eventGenerator.apply(target));
        }, executor).whenComplete((mc, exception) -> {
            target.modLoadingStage = (ModLoadingStage)((Object)((Object)stateChangeHandler.apply(target.modLoadingStage, (Throwable)exception)));
            progressBar.increment();
            ModLoadingContext.get().setActiveContainer(null);
        });
    }

    public IModInfo getModInfo() {
        return this.modInfo;
    }

    public <T extends Record> Optional<T> getCustomExtension(Class<? extends IExtensionPoint<T>> point) {
        return Optional.ofNullable((Record)this.extensionPoints.getOrDefault(point, () -> null).get());
    }

    public <T extends Record> void registerExtensionPoint(Class<? extends IExtensionPoint<T>> point, Supplier<T> extension) {
        this.extensionPoints.put(point, extension);
    }

    public void addConfig(ModConfig modConfig) {
        this.configs.put(modConfig.getType(), modConfig);
    }

    public abstract boolean matches(Object var1);

    public abstract Object getMod();

    @Nullable
    public abstract IEventBus getEventBus();

    protected final <T extends Event> void acceptEvent(T e) {
        IEventBus bus = this.getEventBus();
        if (bus == null) {
            return;
        }
        try {
            LOGGER.trace(Logging.LOADING, "Firing event for modid {} : {}", (Object)this.getModId(), e);
            bus.post(e);
            LOGGER.trace(Logging.LOADING, "Fired event for modid {} : {}", (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }

    protected final <T extends Event> void acceptEvent(EventPriority phase, T e) {
        IEventBus bus = this.getEventBus();
        if (bus == null) {
            return;
        }
        try {
            LOGGER.trace(Logging.LOADING, "Firing event for phase {} for modid {} : {}", (Object)phase, (Object)this.getModId(), e);
            bus.post(phase, e);
            LOGGER.trace(Logging.LOADING, "Fired event for phase {} for modid {} : {}", (Object)phase, (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }
}

