/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.NoopTransition;
import net.neoforged.fml.ThreadSelector;
import net.neoforged.fml.loading.progress.ProgressMeter;

public interface IModStateTransition {
    public static IModStateTransition buildNoopTransition() {
        return new NoopTransition();
    }

    default public <T extends Event> CompletableFuture<Void> build(String name, Executor syncExecutor, Executor parallelExecutor, ProgressMeter progressBar, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        ArrayList futures = new ArrayList();
        this.eventFunctionStream().get().map(f -> f).reduce((head, tail) -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, futures, progressBar, (EventGenerator)head, ModLoadingStage::currentState, (EventGenerator)tail)).ifPresent(last -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, futures, progressBar, (EventGenerator)last, this.nextModLoadingStage(), null));
        CompletableFuture<Void> preSyncTaskCF = preSyncTask.apply(syncExecutor);
        CompletionStage eventDispatchCF = ModList.gather(futures).thenCompose(ModList::completableFutureFromExceptionList);
        CompletionStage postEventDispatchCF = ((CompletableFuture)((CompletableFuture)preSyncTaskCF.thenApplyAsync(n -> {
            progressBar.label(progressBar.name() + ": dispatching " + name);
            return null;
        }, parallelExecutor)).thenComposeAsync(arg_0 -> IModStateTransition.lambda$build$4((CompletableFuture)eventDispatchCF, arg_0), parallelExecutor)).thenApply(r -> {
            postSyncTask.apply(syncExecutor);
            return null;
        });
        return this.finalActivityGenerator().apply(syncExecutor, (CompletableFuture<Void>)postEventDispatchCF);
    }

    default public BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextModLoadingStage() {
        return ModLoadingStage::nextState;
    }

    private <T extends Event> EventGenerator<T> addCompletableFutureTaskForModDispatch(Executor syncExecutor, Executor parallelExecutor, List<CompletableFuture<Void>> completableFutures, ProgressMeter progressBar, EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextState, EventGenerator<T> nextGenerator) {
        Executor selectedExecutor = this.threadSelector().apply(syncExecutor, parallelExecutor);
        BiFunction<Executor, EventGenerator<?>, CompletableFuture<Void>> preDispatchHook = this.preDispatchHook();
        completableFutures.add(preDispatchHook.apply(selectedExecutor, eventGenerator));
        completableFutures.add(ModList.get().futureVisitor(eventGenerator, progressBar, nextState).apply(this.threadSelector().apply(syncExecutor, parallelExecutor)));
        BiFunction<Executor, EventGenerator<?>, CompletableFuture<Void>> postDispatchHook = this.postDispatchHook();
        completableFutures.add(postDispatchHook.apply(selectedExecutor, eventGenerator));
        return nextGenerator;
    }

    public Supplier<Stream<EventGenerator<?>>> eventFunctionStream();

    public ThreadSelector threadSelector();

    public BiFunction<Executor, CompletableFuture<Void>, CompletableFuture<Void>> finalActivityGenerator();

    public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> preDispatchHook();

    public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<Void>> postDispatchHook();

    private static /* synthetic */ CompletionStage lambda$build$4(CompletableFuture eventDispatchCF, Object n) {
        return eventDispatchCF;
    }

    public static interface EventGenerator<T extends Event>
    extends Function<ModContainer, T> {
        public static <FN extends Event> EventGenerator<FN> fromFunction(Function<ModContainer, FN> fn) {
            return fn::apply;
        }
    }
}

