/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeferredWorkQueue {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ModLoadingStage, DeferredWorkQueue> workQueues = new HashMap<ModLoadingStage, DeferredWorkQueue>();
    private final ConcurrentLinkedDeque<TaskInfo> tasks = new ConcurrentLinkedDeque();
    private final ModLoadingStage modLoadingStage;

    public DeferredWorkQueue(ModLoadingStage modLoadingStage) {
        this.modLoadingStage = modLoadingStage;
        workQueues.put(modLoadingStage, this);
    }

    public static Optional<DeferredWorkQueue> lookup(Optional<ModLoadingStage> parallelClass) {
        return Optional.ofNullable(workQueues.get(parallelClass.orElse(null)));
    }

    public void runTasks() {
        if (this.tasks.isEmpty()) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Dispatching synchronous work for work queue {}: {} jobs", (Object)this.modLoadingStage, (Object)this.tasks.size());
        RuntimeException aggregate = new RuntimeException();
        Stopwatch timer = Stopwatch.createStarted();
        this.tasks.forEach(t -> DeferredWorkQueue.makeRunnable(t, Runnable::run, aggregate));
        timer.stop();
        if (aggregate.getSuppressed().length > 0) {
            LOGGER.fatal(Logging.LOADING, "Synchronous work queue completed exceptionally in {}, see suppressed exceptions for details:", (Object)timer, (Object)aggregate);
            throw aggregate;
        }
        LOGGER.debug(Logging.LOADING, "Synchronous work queue completed in {}", (Object)timer);
    }

    private static void makeRunnable(TaskInfo ti, Executor executor, RuntimeException aggregate) {
        executor.execute(() -> {
            Stopwatch timer = Stopwatch.createStarted();
            ModLoadingContext.get().setActiveContainer(ti.owner);
            try {
                ti.future.exceptionally(t -> DeferredWorkQueue.captureException(ti.owner.getModId(), aggregate, t));
                ti.task.run();
            }
            finally {
                ModLoadingContext.get().setActiveContainer(null);
            }
            timer.stop();
            if (timer.elapsed(TimeUnit.SECONDS) >= 1L) {
                LOGGER.warn(Logging.LOADING, "Mod '{}' took {} to run a deferred task.", (Object)ti.owner.getModId(), (Object)timer);
            }
        });
    }

    private static <T> T captureException(String modId, RuntimeException aggregate, Throwable throwable) {
        if (throwable instanceof CompletionException) {
            CompletionException ce = (CompletionException)throwable;
            throwable = ce.getCause();
        }
        aggregate.addSuppressed(throwable);
        LOGGER.error("Mod '{}' encountered an error in a deferred task:", (Object)modId, (Object)throwable);
        return null;
    }

    public CompletableFuture<Void> enqueueWork(ModContainer modInfo, Runnable work) {
        return this.enqueueWork(modInfo, (TaskInfo taskInfo) -> CompletableFuture.runAsync(work, r -> {
            taskInfo.task = r;
        }));
    }

    public <T> CompletableFuture<T> enqueueWork(ModContainer modInfo, Supplier<T> work) {
        return this.enqueueWork(modInfo, (TaskInfo taskInfo) -> CompletableFuture.supplyAsync(work, r -> {
            taskInfo.task = r;
        }));
    }

    private <T> CompletableFuture<T> enqueueWork(ModContainer modInfo, Function<TaskInfo, CompletableFuture<T>> futureGen) {
        TaskInfo taskInfo = new TaskInfo(modInfo);
        CompletableFuture<T> future = futureGen.apply(taskInfo);
        taskInfo.future = future;
        this.tasks.add(taskInfo);
        return future;
    }

    private static class TaskInfo {
        private final ModContainer owner;
        private Runnable task;
        private CompletableFuture<?> future;

        private TaskInfo(ModContainer owner) {
            this.owner = owner;
        }
    }
}

