/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.I18NParser;
import net.neoforged.fml.IBindingsProvider;
import net.neoforged.fml.config.IConfigEvent;
import net.neoforged.fml.loading.FMLLoader;

public class Bindings {
    private static final Bindings INSTANCE = new Bindings();
    private final IBindingsProvider provider;

    private Bindings() {
        List providers = ServiceLoaderUtils.streamServiceLoader(() -> ServiceLoader.load(FMLLoader.getGameLayer(), IBindingsProvider.class), sce -> {}).toList();
        if (providers.size() != 1) {
            throw new IllegalStateException("Could not find bindings provider");
        }
        this.provider = (IBindingsProvider)providers.get(0);
    }

    public static Supplier<IEventBus> getForgeBus() {
        return Bindings.INSTANCE.provider.getForgeBusSupplier();
    }

    public static Supplier<I18NParser> getMessageParser() {
        return Bindings.INSTANCE.provider.getMessageParser();
    }

    public static Supplier<IConfigEvent.ConfigConfig> getConfigConfiguration() {
        return Bindings.INSTANCE.provider.getConfigConfiguration();
    }
}

