/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class NeoForgeDevDistCleaner
implements ClassProcessor {
    private static final Attributes.Name NAME_DISTS = new Attributes.Name("Minecraft-Dists");
    private static final Attributes.Name NAME_DIST = new Attributes.Name("Minecraft-Dist");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker DISTXFORM = MarkerFactory.getMarker((String)"DISTXFORM");
    private final Dist dist;
    private final Set<String> maskedClasses;

    public NeoForgeDevDistCleaner(JarContents minecraftModFile, Dist requestedDist) {
        this.dist = requestedDist;
        this.maskedClasses = NeoForgeDevDistCleaner.getMaskedFiles(minecraftModFile, requestedDist).map(path -> {
            if (path.endsWith(".class")) {
                return path.substring(0, path.length() - ".class".length()).replace('/', '.');
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static boolean supportsDistCleaning(JarContents minecraftModFile) {
        return minecraftModFile.getManifest().getMainAttributes().containsKey(NAME_DISTS);
    }

    @Override
    public ProcessorName name() {
        return ClassProcessorIds.DIST_CLEANER;
    }

    @Override
    public Set<ProcessorName> runsBefore() {
        return Set.of(ClassProcessorIds.COMPUTING_FRAMES);
    }

    @Override
    public Set<ProcessorName> runsAfter() {
        return Set.of();
    }

    @Override
    public ClassProcessor.ComputeFlags processClass(ClassProcessor.TransformationContext context) {
        return ClassProcessor.ComputeFlags.NO_REWRITE;
    }

    @Override
    public boolean handlesClass(ClassProcessor.SelectionContext context) {
        if (this.maskedClasses.contains(context.type().getClassName())) {
            Object[] objectArray = new Object[2];
            objectArray[0] = context.type().getClassName();
            objectArray[1] = switch (this.dist) {
                default -> throw new MatchException(null, null);
                case Dist.CLIENT -> "client";
                case Dist.DEDICATED_SERVER -> "dedicated server";
            };
            String message = String.format("Attempted to load class %s which is not present on the %s", objectArray);
            LOGGER.error(DISTXFORM, message);
            NeoForgeDevDistCleaner.throwUnchecked(new ClassNotFoundException(message));
        }
        return false;
    }

    private static <T, X extends Throwable> void throwUnchecked(T throwable) throws X {
        throw (Throwable)throwable;
    }

    public static Stream<String> getMaskedFiles(JarContents minecraftJar, Dist currentDist) {
        String dist;
        Manifest manifest = minecraftJar.getManifest();
        String dists = manifest.getMainAttributes().getValue(NAME_DISTS);
        if (dists == null) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.neodev_missing_dists_attribute", NAME_DISTS));
        }
        switch (currentDist) {
            default: {
                throw new MatchException(null, null);
            }
            case CLIENT: {
                String string = "client";
                break;
            }
            case DEDICATED_SERVER: {
                String string = dist = "server";
            }
        }
        if (Arrays.stream(dists.split("\\s+")).allMatch(s -> s.equals(dist))) {
            return Stream.empty();
        }
        if (Arrays.stream(dists.split("\\s+")).noneMatch(s -> s.equals(dist))) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.neodev_missing_appropriate_dist", dist, NAME_DISTS));
        }
        return manifest.getEntries().entrySet().stream().filter(entry -> {
            String fileDist = ((Attributes)entry.getValue()).getValue(NAME_DIST);
            return fileDist != null && !fileDist.equals(dist);
        }).map(Map.Entry::getKey);
    }
}

