/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.stream.Stream;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarmoduleinfo.JarModuleInfo;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.fml.loading.modscan.Scanner;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import net.neoforged.neoforgespi.locating.ModFileInfoParser;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ModFile
implements IModFile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEFAULT_ACCESS_TRANSFORMER = "META-INF/accesstransformer.cfg";
    private final String id;
    private final String jarVersion;
    private ModFileDiscoveryAttributes discoveryAttributes;
    private Map<String, Object> fileProperties;
    private List<IModLanguageLoader> loaders;
    private final JarContents contents;
    private final JarModuleInfo jarModuleInfo;
    @Nullable
    private volatile ModuleDescriptor moduleDescriptor;
    private final IModFile.Type modFileType;
    private final IModFileInfo modFileInfo;
    private final List<ModFileParser.MixinConfig> mixinConfigs;
    private final List<String> accessTransformers;
    @Nullable
    private CompletableFuture<ModFileScanData> futureScanResult;
    public static final Attributes.Name TYPE = new Attributes.Name("FMLModType");

    public ModFile(JarContents contents, ModFileInfoParser parser, ModFileDiscoveryAttributes attributes) {
        this(contents, null, parser, ModFile.parseType(contents), attributes);
    }

    public ModFile(JarContents contents, @Nullable JarModuleInfo metadata, ModFileInfoParser parser, ModFileDiscoveryAttributes attributes) {
        this(contents, metadata, parser, ModFile.parseType(contents), attributes);
    }

    public ModFile(JarContents contents, @Nullable JarModuleInfo metadata, ModFileInfoParser parser, IModFile.Type type, ModFileDiscoveryAttributes discoveryAttributes) {
        this.contents = Objects.requireNonNull(contents, "jar");
        this.discoveryAttributes = Objects.requireNonNull(discoveryAttributes, "discoveryAttributes");
        this.modFileType = Objects.requireNonNull(type, "type");
        this.jarVersion = Optional.ofNullable(this.getContents().getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION)).orElse("0.0NONE");
        this.modFileInfo = ModFileParser.readModList(this, Objects.requireNonNull(parser, "parser"));
        this.jarModuleInfo = metadata != null ? metadata : JarModuleInfo.from(contents);
        this.id = this.modFileInfo != null && !this.modFileInfo.getMods().isEmpty() ? this.modFileInfo.getMods().getFirst().getModId() : this.jarModuleInfo.name();
        if (this.modFileInfo != null) {
            LOGGER.debug(LogMarkers.LOADING, "Loading mod file {} with languages {}", (Object)this.getFilePath(), this.modFileInfo.requiredLanguageLoaders());
            this.mixinConfigs = ModFileParser.getMixinConfigs(this.modFileInfo);
            this.mixinConfigs.forEach(mc -> LOGGER.debug(LogMarkers.LOADING, "Found mixin config {}", mc));
            this.accessTransformers = ModFileParser.getAccessTransformers(this.modFileInfo).map(list -> list.stream().filter(path -> {
                if (!this.getContents().containsFile((String)path)) {
                    LOGGER.error(LogMarkers.LOADING, "Access transformer file {} provided by mod {} does not exist!", path, (Object)this.id);
                    return false;
                }
                return true;
            })).orElseGet(() -> {
                if (this.getContents().containsFile(DEFAULT_ACCESS_TRANSFORMER)) {
                    return Stream.of(DEFAULT_ACCESS_TRANSFORMER);
                }
                return Stream.empty();
            }).toList();
        } else {
            this.mixinConfigs = List.of();
            this.accessTransformers = List.of();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JarContents getContents() {
        return this.contents;
    }

    @Override
    public Supplier<Map<String, Object>> getSubstitutionMap() {
        return () -> ImmutableMap.builder().put((Object)"jarVersion", (Object)this.jarVersion).putAll(this.fileProperties).build();
    }

    public List<IModLanguageLoader> getLoaders() {
        return this.loaders;
    }

    @Override
    public IModFile.Type getType() {
        return this.modFileType;
    }

    @Override
    public Path getFilePath() {
        return this.getContents().getPrimaryPath();
    }

    @Override
    public List<IModInfo> getModInfos() {
        return this.modFileInfo.getMods();
    }

    public List<String> getAccessTransformers() {
        return this.accessTransformers;
    }

    public List<ModFileParser.MixinConfig> getMixinConfigs() {
        return this.mixinConfigs;
    }

    public CompletionStage<ModFileScanData> startScan(Executor executor) {
        if (this.futureScanResult != null) {
            throw new IllegalStateException("The mod file scan was already started.");
        }
        this.futureScanResult = CompletableFuture.supplyAsync(() -> new Scanner(this).scan(), executor);
        return this.futureScanResult;
    }

    @Override
    public ModFileScanData getScanResult() {
        if (this.futureScanResult == null) {
            throw new IllegalStateException("Scanning of this mod file has not started yet.");
        }
        try {
            return this.futureScanResult.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for mod file scan to complete.");
        }
    }

    public void setFileProperties(Map<String, Object> fileProperties) {
        this.fileProperties = fileProperties;
    }

    public void identifyLanguage() {
        this.loaders = this.modFileInfo.requiredLanguageLoaders().stream().map(spec -> FMLLoader.getLanguageLoadingProvider().findLanguage(this, spec.languageName(), spec.acceptedVersions())).toList();
    }

    public String toString() {
        if (this.discoveryAttributes.parent() != null) {
            return String.valueOf(this.discoveryAttributes.parent()) + " > " + String.valueOf(this.contents);
        }
        return this.contents.toString();
    }

    @Override
    public String getFileName() {
        return this.getFilePath().getFileName().toString();
    }

    @Override
    public ModFileDiscoveryAttributes getDiscoveryAttributes() {
        return this.discoveryAttributes;
    }

    public void setDiscoveryAttributes(ModFileDiscoveryAttributes discoveryAttributes) {
        this.discoveryAttributes = discoveryAttributes;
    }

    @Override
    public IModFileInfo getModFileInfo() {
        return this.modFileInfo;
    }

    public ArtifactVersion getJarVersion() {
        return new DefaultArtifactVersion(this.jarVersion);
    }

    private static IModFile.Type parseType(JarContents contents) {
        String value = contents.getManifest().getMainAttributes().getValue(TYPE);
        return value != null ? IModFile.Type.valueOf(value) : IModFile.Type.MOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor result = this.moduleDescriptor;
        if (result == null) {
            ModFile modFile = this;
            synchronized (modFile) {
                result = this.moduleDescriptor;
                if (result == null) {
                    this.moduleDescriptor = result = this.jarModuleInfo.createDescriptor(this.contents);
                }
            }
        }
        return result;
    }

    public void close() {
        try {
            this.contents.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close mod file {}", (Object)this, (Object)e);
        }
    }
}

