/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.spongepowered.asm.service.IGlobalPropertyService;
import org.spongepowered.asm.service.IPropertyKey;

public class FMLMixinGlobalProperties
implements IGlobalPropertyService {
    private static final Map<String, Object> PROPERTIES = new HashMap<String, Object>();

    public IPropertyKey resolveKey(String name) {
        return new StringKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getProperty(IPropertyKey key) {
        Map<String, Object> map = PROPERTIES;
        synchronized (map) {
            return (T)PROPERTIES.get(this.getKeyName(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(IPropertyKey key, Object value) {
        Map<String, Object> map = PROPERTIES;
        synchronized (map) {
            PROPERTIES.put(this.getKeyName(key), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getProperty(IPropertyKey key, T defaultValue) {
        Map<String, Object> map = PROPERTIES;
        synchronized (map) {
            return (T)PROPERTIES.getOrDefault(this.getKeyName(key), defaultValue);
        }
    }

    public String getPropertyString(IPropertyKey key, String defaultValue) {
        return Objects.requireNonNullElse((String)PROPERTIES.get(this.getKeyName(key)), defaultValue);
    }

    private String getKeyName(IPropertyKey key) {
        return ((StringKey)key).name();
    }

    record StringKey(String name) implements IPropertyKey
    {
    }
}

