/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarmoduleinfo;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.ByteBuffer;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarmoduleinfo.JarModuleInfo;
import net.neoforged.fml.jarmoduleinfo.ModuleDescriptorFactory;
import org.jetbrains.annotations.Nullable;

class ModuleJarModuleInfo
implements JarModuleInfo {
    private final byte[] originalDescriptorBytes;
    private final ModuleDescriptor originalDescriptor;

    public ModuleJarModuleInfo(JarResource moduleInfo) {
        try {
            this.originalDescriptorBytes = moduleInfo.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read module-info.class from " + String.valueOf(moduleInfo), e);
        }
        this.originalDescriptor = ModuleDescriptor.read(ByteBuffer.wrap(this.originalDescriptorBytes));
    }

    @Override
    public ModuleDescriptor createDescriptor(JarContents contents) {
        ModuleDescriptor fullDescriptor = ModuleDescriptor.read(ByteBuffer.wrap(this.originalDescriptorBytes), () -> ModuleDescriptorFactory.scanModulePackages(contents));
        ModuleDescriptor.Builder builder = ModuleDescriptor.newAutomaticModule(fullDescriptor.name());
        fullDescriptor.rawVersion().ifPresent(builder::version);
        builder.packages(fullDescriptor.packages());
        fullDescriptor.provides().forEach(builder::provides);
        return builder.build();
    }

    @Override
    public String name() {
        return this.originalDescriptor.name();
    }

    @Override
    @Nullable
    public String version() {
        return this.originalDescriptor.rawVersion().orElse(null);
    }
}

