/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarmoduleinfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarmoduleinfo.JlsConstants;
import net.neoforged.fml.jarmoduleinfo.NameAndVersion;

final class ModuleDescriptorFactory {
    private static final Pattern DASH_VERSION = Pattern.compile("-([.\\d]+)");
    private static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
    private static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
    private static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");
    private static final Pattern MODULE_VERSION = Pattern.compile("(?<=^|-)([\\d][.\\d]*)");
    private static final Pattern NUMBERLIKE_PARTS = Pattern.compile("(?<=^|\\.)([0-9]+)");
    private static final List<String> ILLEGAL_KEYWORDS = List.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
    private static final Pattern KEYWORD_PARTS = Pattern.compile("(?<=^|\\.)(" + String.join((CharSequence)"|", ILLEGAL_KEYWORDS) + ")(?=\\.|$)");

    private ModuleDescriptorFactory() {
    }

    static NameAndVersion computeNameAndVersion(Path path) {
        Matcher mat;
        Path artifactNameMaybe;
        Path artifactMaybe;
        Path versionMaybe = path.getParent();
        if (versionMaybe != null && (artifactMaybe = versionMaybe.getParent()) != null && (artifactNameMaybe = artifactMaybe.getFileName()) != null && path.getFileName().toString().startsWith(String.valueOf(artifactNameMaybe) + "-" + versionMaybe.getFileName().toString())) {
            String name = artifactMaybe.getFileName().toString();
            String ver = versionMaybe.getFileName().toString();
            Matcher mat2 = MODULE_VERSION.matcher(ver);
            if (mat2.find()) {
                String potential = ver.substring(mat2.start());
                ver = ModuleDescriptorFactory.safeParseVersion(potential, path.getFileName().toString());
                return new NameAndVersion(ModuleDescriptorFactory.cleanModuleName(name), ver);
            }
            return new NameAndVersion(ModuleDescriptorFactory.cleanModuleName(name), null);
        }
        String fn = path.getFileName().toString();
        int lastDot = fn.lastIndexOf(46);
        if (lastDot > 0) {
            fn = fn.substring(0, lastDot);
        }
        if ((mat = DASH_VERSION.matcher(fn)).find()) {
            String potential = fn.substring(mat.start() + 1);
            String ver = ModuleDescriptorFactory.safeParseVersion(potential, path.getFileName().toString());
            String name = mat.replaceAll("");
            return new NameAndVersion(ModuleDescriptorFactory.cleanModuleName(name), ver);
        }
        return new NameAndVersion(ModuleDescriptorFactory.cleanModuleName(fn), null);
    }

    private static String safeParseVersion(String ver, String filename) {
        try {
            int len = ver.length();
            if (len == 0) {
                throw new IllegalArgumentException("Error parsing version info from " + filename + ": Empty Version String");
            }
            char last = ver.charAt(len - 1);
            if (last == '.' || last == '+' || last == '-') {
                if (len == 1) {
                    throw new IllegalArgumentException("Error parsing version info from " + filename + ": Invalid version \"" + ver + "\"");
                }
                ver = ver.substring(0, len - 1);
            }
            return ModuleDescriptor.Version.parse(ver).toString();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error parsing version info from " + filename + " (" + ver + "): " + e.getMessage(), e);
        }
    }

    private static String cleanModuleName(String mn) {
        int len;
        mn = NON_ALPHANUM.matcher(mn).replaceAll(".");
        if (!(mn = REPEATING_DOTS.matcher(mn).replaceAll(".")).isEmpty() && mn.charAt(0) == '.') {
            mn = LEADING_DOTS.matcher(mn).replaceAll("");
        }
        if ((len = mn.length()) > 0 && mn.charAt(len - 1) == '.') {
            mn = TRAILING_DOTS.matcher(mn).replaceAll("");
        }
        mn = NUMBERLIKE_PARTS.matcher(mn).replaceAll("_$1");
        mn = KEYWORD_PARTS.matcher(mn).replaceAll("_$1");
        return mn;
    }

    public static void scanAutomaticModule(JarContents jar, ModuleDescriptor.Builder builder, String ... excludedRootDirectories) {
        Set<String> ignoredRootDirs = Set.of(excludedRootDirectories);
        HashSet<String> packageNames = new HashSet<String>();
        HashMap serviceProviderFiles = new HashMap();
        jar.visitContent((relativePath, resource) -> {
            String relativeDir;
            String packageName;
            int lastSeparator;
            if (relativePath.startsWith("META-INF/services/")) {
                String filename = relativePath.substring(relativePath.lastIndexOf(47) + 1);
                if (JlsConstants.isTypeName(filename)) {
                    serviceProviderFiles.put(filename, resource.retain());
                }
            } else if (relativePath.endsWith(".class") && (lastSeparator = relativePath.lastIndexOf(47)) > 0 && JlsConstants.isTypeName(packageName = (relativeDir = relativePath.substring(0, lastSeparator)).replace('/', '.'))) {
                packageNames.add(packageName);
            }
        });
        builder.packages(packageNames);
        for (Map.Entry serviceProviderEntry : serviceProviderFiles.entrySet()) {
            String serviceProviderName = (String)serviceProviderEntry.getKey();
            try {
                BufferedReader reader = ((JarResource)serviceProviderEntry.getValue()).bufferedReader(StandardCharsets.UTF_8);
                try {
                    ModuleDescriptorFactory.parseServiceFile(serviceProviderName, reader, packageNames, builder);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to parse service provider file " + serviceProviderName + " in " + String.valueOf(jar), e);
            }
        }
    }

    private static void parseServiceFile(String serviceName, BufferedReader reader, Set<String> packageNames, ModuleDescriptor.Builder builder) throws IOException {
        String line;
        ArrayList<String> providerClasses = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            int startOfComment = line.indexOf(35);
            if (startOfComment != -1) {
                line = line.substring(0, startOfComment);
            }
            if ((line = line.trim()).isEmpty()) continue;
            String packageName = JlsConstants.getPackageName(line);
            if (!packageNames.contains(packageName)) {
                String msg = "Service provider file " + serviceName + " contains service that is not in this Jar file: " + line;
                throw new InvalidModuleDescriptorException(msg);
            }
            providerClasses.add(line);
        }
        if (!providerClasses.isEmpty()) {
            builder.provides(serviceName, providerClasses);
        }
    }

    public static Set<String> scanModulePackages(JarContents jar) {
        HashSet packageNames = new HashSet();
        jar.visitContent((relativePath, resource) -> {
            int lastSeparator = relativePath.lastIndexOf(47);
            if (lastSeparator < 1) {
                return;
            }
            String packageName = relativePath.substring(0, lastSeparator).replace('/', '.');
            if (JlsConstants.isTypeName(packageName)) {
                packageNames.add(packageName);
            }
        });
        return Set.copyOf(packageNames);
    }
}

