/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.neoforged.fml.util.ClasspathResourceUtils;
import org.jetbrains.annotations.Nullable;

public class ResourceMaskingClassLoader
extends ClassLoader {
    private final Set<Path> maskedClasspathElements;

    public ResourceMaskingClassLoader(ClassLoader parent, Set<Path> maskedClasspathElements) {
        super(Objects.requireNonNull(parent, "parent"));
        this.maskedClasspathElements = maskedClasspathElements;
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        URL resource = this.getParent().getResource(name);
        if (resource == null) {
            return null;
        }
        Path resourceRoot = ClasspathResourceUtils.getRootFromResourceUrl(name, resource);
        if (this.maskedClasspathElements.contains(resourceRoot)) {
            try {
                Enumeration<URL> resources = this.getResources(name);
                resource = resources.hasMoreElements() ? resources.nextElement() : null;
            }
            catch (IOException e) {
                resource = null;
            }
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return new FilteringEnumeration(super.getResources(name), name);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    class FilteringEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> delegate;
        private final String relativePath;
        @Nullable
        private URL nextElement;

        public FilteringEnumeration(Enumeration<URL> delegate, String relativePath) {
            this.delegate = delegate;
            this.relativePath = relativePath;
            this.seekNextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextElement != null;
        }

        @Override
        public URL nextElement() {
            URL result = this.nextElement;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.seekNextElement();
            return result;
        }

        private void seekNextElement() {
            while (this.delegate.hasMoreElements()) {
                URL el = this.delegate.nextElement();
                Path root = ClasspathResourceUtils.getRootFromResourceUrl(this.relativePath, el);
                if (ResourceMaskingClassLoader.this.maskedClasspathElements.contains(root)) continue;
                this.nextElement = el;
                return;
            }
            this.nextElement = null;
        }
    }
}

