/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.transformation;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.neoforged.neoforgespi.transformation.BaseSimpleProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.NameValidation;
import net.neoforged.neoforgespi.transformation.SimpleTransformationContext;
import org.objectweb.asm.tree.MethodNode;

public abstract non-sealed class SimpleMethodProcessor
extends BaseSimpleProcessor {
    private final AtomicReference<Map<String, Set<String>>> targetsByClass = new AtomicReference();

    public abstract void transform(MethodNode var1, SimpleTransformationContext var2);

    public abstract Set<Target> targets();

    private Map<String, Set<String>> targetsByClass() {
        return this.targetsByClass.updateAndGet(map -> map != null ? map : this.targets().stream().collect(Collectors.groupingBy(Target::className, Collectors.mapping(t -> t.methodName() + t.methodDescriptor(), Collectors.toSet()))));
    }

    @Override
    public final boolean handlesClass(ClassProcessor.SelectionContext context) {
        return this.targetsByClass().containsKey(context.type().getClassName());
    }

    @Override
    public final ClassProcessor.ComputeFlags processClass(ClassProcessor.TransformationContext context) {
        Set<String> targetMethods = this.targetsByClass().get(context.type().getClassName());
        if (targetMethods == null) {
            return ClassProcessor.ComputeFlags.NO_REWRITE;
        }
        boolean transformed = false;
        for (MethodNode method : context.node().methods) {
            if (!targetMethods.contains(method.name + method.desc)) continue;
            this.transform(method, context);
            transformed = true;
        }
        return transformed ? ClassProcessor.ComputeFlags.COMPUTE_FRAMES : ClassProcessor.ComputeFlags.NO_REWRITE;
    }

    public record Target(String className, String methodName, String methodDescriptor) {
        public Target {
            NameValidation.validateClassName(className);
            NameValidation.validateMethod(methodName, methodDescriptor);
        }
    }
}

