/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.locating;

import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IModFileReader;
import org.jetbrains.annotations.Nullable;

public record ModFileDiscoveryAttributes(@Nullable IModFile parent, @Nullable IModFileReader reader, @Nullable IModFileCandidateLocator locator, @Nullable IDependencyLocator dependencyLocator) {
    public static final ModFileDiscoveryAttributes DEFAULT = new ModFileDiscoveryAttributes(null, null, null, null);

    public ModFileDiscoveryAttributes withParent(IModFile parent) {
        return new ModFileDiscoveryAttributes(parent, this.reader, this.locator, this.dependencyLocator);
    }

    public ModFileDiscoveryAttributes withReader(IModFileReader reader) {
        return new ModFileDiscoveryAttributes(this.parent, reader, this.locator, this.dependencyLocator);
    }

    public ModFileDiscoveryAttributes withLocator(IModFileCandidateLocator locator) {
        return new ModFileDiscoveryAttributes(this.parent, this.reader, locator, this.dependencyLocator);
    }

    public ModFileDiscoveryAttributes withDependencyLocator(IDependencyLocator dependencyLocator) {
        return new ModFileDiscoveryAttributes(this.parent, this.reader, this.locator, dependencyLocator);
    }

    public ModFileDiscoveryAttributes merge(ModFileDiscoveryAttributes attributes) {
        return new ModFileDiscoveryAttributes(attributes.parent != null ? attributes.parent : this.parent, attributes.reader != null ? attributes.reader : this.reader, attributes.locator != null ? attributes.locator : this.locator, attributes.dependencyLocator != null ? attributes.dependencyLocator : this.dependencyLocator);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (this.parent != null) {
            result.append("parent: ");
            result.append(this.parent.getFilePath().getFileName());
        }
        if (this.locator != null) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append("locator: ");
            result.append(this.locator);
        }
        if (this.dependencyLocator != null) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append("locator: ");
            result.append(this.dependencyLocator);
        }
        if (this.reader != null) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append("reader: ");
            result.append(this.reader);
        }
        result.append("]");
        return result.toString();
    }
}

