/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.util;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.util.PathPrettyPrinting;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IOrderedProvider;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ServiceLoaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderUtil.class);

    private ServiceLoaderUtil() {
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass) {
        return ServiceLoaderUtil.loadServices(context, serviceClass, List.of());
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass, Predicate<Class<? extends T>> filter) {
        return ServiceLoaderUtil.loadServices(context, serviceClass, List.of(), filter);
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass, Collection<T> additionalServices) {
        return ServiceLoaderUtil.loadServices(context, serviceClass, additionalServices, ignored -> true);
    }

    public static <T> List<T> loadServices(ILaunchContext context, Class<T> serviceClass, Collection<T> additionalServices, Predicate<Class<? extends T>> filter) {
        Stream<Object> serviceLoaderServices = context.loadServices(serviceClass).filter(p -> {
            if (!filter.test(p.type())) {
                LOGGER.debug("Filtering out service provider {} for service class {}", p.type(), (Object)serviceClass);
                return false;
            }
            return true;
        }).map(p -> {
            try {
                return p.get();
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.error("Failed to load implementation for {}", (Object)serviceClass, (Object)sce);
                return null;
            }
        }).filter(Objects::nonNull);
        Stream<Object> servicesStream = Stream.concat(additionalServices.stream(), serviceLoaderServices).distinct();
        boolean applyPriority = IOrderedProvider.class.isAssignableFrom(serviceClass);
        if (applyPriority) {
            servicesStream = servicesStream.sorted(Comparator.comparingInt(service -> ((IOrderedProvider)service).getPriority()).reversed());
        }
        List<Object> services = servicesStream.toList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogMarkers.CORE, "Found {} implementations of {}:", (Object)services.size(), (Object)serviceClass.getSimpleName());
            for (Object service2 : services) {
                String priorityPrefix = "";
                if (applyPriority) {
                    priorityPrefix = String.format(Locale.ROOT, "%8d - ", ((IOrderedProvider)service2).getPriority());
                }
                if (additionalServices.contains(service2)) {
                    LOGGER.debug(LogMarkers.CORE, "\t{}[built-in] {}", (Object)priorityPrefix, (Object)ServiceLoaderUtil.identifyService(service2));
                    continue;
                }
                LOGGER.debug(LogMarkers.CORE, "\t{}{}", (Object)priorityPrefix, (Object)ServiceLoaderUtil.identifyService(service2));
            }
        }
        return services;
    }

    private static String identifyService(Object o) {
        String sourcePath = ServiceLoaderUtil.identifySourcePath(o);
        return o.getClass().getName() + " from " + sourcePath;
    }

    public static String identifySourcePath(Object object) {
        Path fsLocation;
        URL codeLocation = object.getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            fsLocation = Path.of(codeLocation.toURI());
        }
        catch (URISyntaxException e) {
            return codeLocation.toString();
        }
        return PathPrettyPrinting.prettyPrint(fsLocation);
    }
}

