/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.startup.DevAgent;
import net.neoforged.fml.startup.SelfAttach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentationHelper.class);

    private InstrumentationHelper() {
    }

    public static Instrumentation obtainInstrumentation() {
        StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        String callingPackage = stackWalker.getCallerClass().getPackageName();
        if (!callingPackage.equals(FMLLoader.class.getPackageName())) {
            throw new IllegalStateException("This method may only be called by FML");
        }
        ArrayList<Exception> storedExceptions = new ArrayList<Exception>();
        try {
            return InstrumentationHelper.getFromOurOwnAgent();
        }
        catch (Exception e) {
            storedExceptions.add(e);
            try {
                String classpathItem = SelfAttach.getClassPathItem();
                String command = ProcessHandle.current().info().command().orElseThrow(() -> new RuntimeException("Could not self-attach: failed to determine our own commandline"));
                Process process = new ProcessBuilder(command, "-cp", classpathItem, SelfAttach.class.getName(), DevAgent.class.getName()).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).inheritIO().start();
                process.getOutputStream().close();
                int result = process.waitFor();
                if (result != 0) {
                    throw new RuntimeException("Could not self-attach agent: " + result);
                }
                return InstrumentationHelper.getFromOurOwnAgent();
            }
            catch (Exception e2) {
                storedExceptions.add(e2);
                try {
                    Class<?> byteBuddyAgent = Class.forName("net.bytebuddy.agent.ByteBuddyAgent", true, ClassLoader.getSystemClassLoader());
                    Instrumentation instrumentation = (Instrumentation)byteBuddyAgent.getMethod("install", new Class[0]).invoke(null, new Object[0]);
                    LOG.info("Using byte-buddy fallback");
                    return instrumentation;
                }
                catch (Exception e3) {
                    storedExceptions.add(e3);
                    IllegalStateException e4 = new IllegalStateException("Failed to obtain instrumentation.");
                    storedExceptions.forEach(e4::addSuppressed);
                    throw e4;
                }
            }
        }
    }

    private static Instrumentation getFromOurOwnAgent() throws Exception {
        Class<?> devAgent = Class.forName("net.neoforged.fml.startup.DevAgent", true, ClassLoader.getSystemClassLoader());
        Instrumentation instrumentation = (Instrumentation)devAgent.getMethod("getInstrumentation", new Class[0]).invoke(null, new Object[0]);
        if (instrumentation == null) {
            throw new IllegalStateException("Our DevAgent was not attached. Pass an appropriate -javaagent parameter.");
        }
        LOG.info("Using our own agent");
        return instrumentation;
    }
}

