/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.util.ClasspathResourceUtils;
import net.neoforged.neoforgespi.ILaunchContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RequiredSystemFiles
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RequiredSystemFiles.class);
    private static final String COMMON_CLASS = "net/minecraft/DetectedVersion.class";
    private static final String CLIENT_CLASS = "net/minecraft/client/Minecraft.class";
    private static final String COMMON_RESOURCE_ROOT = "data/.mcassetsroot";
    private static final String CLIENT_RESOURCE_ROOT = "assets/.mcassetsroot";
    private static final String NEOFORGE_COMMON_CLASS = "net/neoforged/neoforge/common/NeoForgeMod.class";
    private static final String NEOFORGE_CLIENT_CLASS = "net/neoforged/neoforge/client/ClientNeoForgeMod.class";
    private JarContents commonClasses;
    private JarContents commonResources;
    private JarContents clientClasses;
    private JarContents clientResources;
    private JarContents neoForgeCommonClasses;
    private JarContents neoForgeClientClasses;
    private JarContents neoForgeResources;

    private RequiredSystemFiles() {
    }

    public boolean areNeoForgeAndMinecraftSeparate() {
        return Collections.disjoint(this.getMinecraftJarComponents(), this.getNeoForgeJarComponents());
    }

    public void checkForMissingMinecraftFiles(boolean clientRequired) {
        ArrayList<String> missingFiles = new ArrayList<String>();
        if (this.commonClasses == null) {
            missingFiles.add(COMMON_CLASS);
        }
        if (this.commonResources == null) {
            missingFiles.add(COMMON_RESOURCE_ROOT);
        }
        if (this.neoForgeCommonClasses == null) {
            missingFiles.add(NEOFORGE_COMMON_CLASS);
        }
        if (this.neoForgeResources == null) {
            missingFiles.add("NeoForge MANIFEST.MF");
        }
        if (clientRequired) {
            if (this.clientClasses == null) {
                missingFiles.add(CLIENT_CLASS);
            }
            if (this.clientResources == null) {
                missingFiles.add(CLIENT_RESOURCE_ROOT);
            }
            if (this.neoForgeClientClasses == null) {
                missingFiles.add(NEOFORGE_CLIENT_CLASS);
            }
        }
        if (!missingFiles.isEmpty()) {
            List foundRoots = this.getAll().stream().distinct().toList();
            LOG.error("Couldn't find {} on classpath, while we did find other required files in: {}", missingFiles, foundRoots);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.missing_minecraft_jar", new Object[0]));
        }
    }

    public static RequiredSystemFiles find(ILaunchContext context, ClassLoader loader) {
        ArrayList<JarContents> locatedRoots = new ArrayList<JarContents>();
        RequiredSystemFiles result = new RequiredSystemFiles();
        try {
            result.commonClasses = RequiredSystemFiles.findAndOpen(context, loader, locatedRoots, COMMON_CLASS);
            result.commonResources = RequiredSystemFiles.findAndOpen(context, loader, locatedRoots, COMMON_RESOURCE_ROOT);
            result.clientClasses = RequiredSystemFiles.findAndOpen(context, loader, locatedRoots, CLIENT_CLASS);
            result.clientResources = RequiredSystemFiles.findAndOpen(context, loader, locatedRoots, CLIENT_RESOURCE_ROOT);
            result.neoForgeCommonClasses = RequiredSystemFiles.findAndOpen(context, loader, locatedRoots, NEOFORGE_COMMON_CLASS);
            result.neoForgeClientClasses = RequiredSystemFiles.findAndOpen(context, loader, locatedRoots, NEOFORGE_CLIENT_CLASS);
            result.neoForgeResources = RequiredSystemFiles.findNeoForgeResources(locatedRoots, loader);
        }
        catch (Exception e) {
            RequiredSystemFiles.closeAll(locatedRoots);
            throw e;
        }
        return result;
    }

    private static JarContents findNeoForgeResources(List<JarContents> locatedRoots, ClassLoader loader) {
        for (JarContents root : locatedRoots) {
            if (!RequiredSystemFiles.isNeoForgeManifest(root.getManifest())) continue;
            LOG.debug("Found NeoForge MANIFEST.MF in {}", (Object)root);
            return root;
        }
        List<Path> manifestRoots = ClasspathResourceUtils.findFileSystemRootsOfFileOnClasspath(loader, "META-INF/MANIFEST.MF");
        for (Path manifestRoot : manifestRoots) {
            if (!Files.isDirectory(manifestRoot, new LinkOption[0]) || !RequiredSystemFiles.isNeoForgeManifest(manifestRoot.resolve("META-INF/MANIFEST.MF"))) continue;
            return RequiredSystemFiles.openOrThrow(manifestRoot);
        }
        return null;
    }

    @Nullable
    private static JarContents findAndOpen(ILaunchContext context, ClassLoader loader, List<JarContents> alreadyOpened, String relativePath) {
        for (JarContents contents : alreadyOpened) {
            if (!contents.containsFile(relativePath)) continue;
            return contents;
        }
        List<Path> roots = ClasspathResourceUtils.findFileSystemRootsOfFileOnClasspath(loader, relativePath);
        for (Path path : roots) {
            if (context.isLocated(path)) continue;
            JarContents jar = RequiredSystemFiles.openOrThrow(path);
            alreadyOpened.add(jar);
            return jar;
        }
        return null;
    }

    private static JarContents openOrThrow(Path root) {
        try {
            return JarContents.ofPath(root);
        }
        catch (IOException e) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]).withAffectedPath(root).withCause(e));
        }
    }

    private static boolean isNeoForgeManifest(Path path) {
        boolean bl;
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            Manifest manifest = new Manifest(in);
            bl = RequiredSystemFiles.isNeoForgeManifest(manifest);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug("Failed to read manifest at {}: {}", (Object)path, (Object)e);
                return false;
            }
        }
        in.close();
        return bl;
    }

    private static boolean isNeoForgeManifest(Manifest manifest) {
        return "neoforge".equals(manifest.getMainAttributes().getValue("FML-System-Mods"));
    }

    public List<JarContents> getAll() {
        return Stream.of(this.commonClasses, this.commonResources, this.clientClasses, this.clientResources, this.neoForgeCommonClasses, this.neoForgeClientClasses, this.neoForgeResources).filter(Objects::nonNull).toList();
    }

    public List<JarContents> getClassesRoots() {
        return Stream.of(this.commonClasses, this.clientClasses, this.neoForgeCommonClasses, this.neoForgeClientClasses).filter(Objects::nonNull).toList();
    }

    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    public JarContents getCommonClasses() {
        return this.commonClasses;
    }

    public JarContents getCommonResources() {
        return this.commonResources;
    }

    public JarContents getClientClasses() {
        return this.clientClasses;
    }

    public JarContents getClientResources() {
        return this.clientResources;
    }

    public JarContents getNeoForgeCommonClasses() {
        return this.neoForgeCommonClasses;
    }

    public JarContents getNeoForgeClientClasses() {
        return this.neoForgeClientClasses;
    }

    public JarContents getNeoForgeResources() {
        return this.neoForgeResources;
    }

    private static void closeAll(Iterable<JarContents> locatedRoots) {
        for (JarContents root : locatedRoots) {
            try {
                root.close();
            }
            catch (IOException ex) {
                LOG.error("Couldn't close Minecraft jar file.", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() {
        RequiredSystemFiles.closeAll(this.getAll());
    }

    public List<JarContents> getMinecraftJarComponents() {
        return RequiredSystemFiles.uniqueAndNonNull(this.commonResources, this.commonClasses, this.clientResources, this.clientClasses);
    }

    public List<JarContents> getNeoForgeJarComponents() {
        return RequiredSystemFiles.uniqueAndNonNull(this.neoForgeResources, this.neoForgeCommonClasses, this.neoForgeClientClasses);
    }

    private static List<JarContents> uniqueAndNonNull(JarContents ... contents) {
        ArrayList<JarContents> result = new ArrayList<JarContents>(contents.length);
        for (JarContents content : contents) {
            if (content == null || result.contains(content)) continue;
            result.add(content);
        }
        return result;
    }
}

