/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import java.lang.module.ModuleDescriptor;
import java.util.Objects;
import net.neoforged.fml.classloading.JarMetadata;
import net.neoforged.fml.classloading.LazyJarMetadata;
import net.neoforged.fml.classloading.ModuleDescriptorFactory;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.neoforgespi.locating.IModFile;

public final class ModJarMetadata
extends LazyJarMetadata
implements JarMetadata {
    private final JarContents jar;
    private IModFile modFile;

    public ModJarMetadata(JarContents jar) {
        this.jar = jar;
    }

    public void setModFile(IModFile file) {
        this.modFile = file;
    }

    @Override
    public String name() {
        return this.modFile.getId();
    }

    @Override
    public String version() {
        return this.modFile.getModFileInfo().versionString();
    }

    @Override
    public ModuleDescriptor computeDescriptor() {
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name()).version(this.version());
        ModuleDescriptorFactory.scanAutomaticModule(this.jar, bld, "assets", "data");
        this.modFile.getModFileInfo().usesServices().forEach(bld::uses);
        return bld.build();
    }

    public IModFile modFile() {
        return this.modFile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModJarMetadata that = (ModJarMetadata)obj;
        return Objects.equals(this.modFile, that.modFile);
    }

    public int hashCode() {
        return Objects.hash(this.modFile);
    }

    public String toString() {
        return "ModJarMetadata[modFile=" + String.valueOf(this.modFile) + "]";
    }
}

