/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import net.neoforged.fml.startup.FatalStartupException;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IModFileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class EarlyServiceDiscovery {
    private static final Logger LOGGER = LogManager.getLogger(EarlyServiceDiscovery.class);
    private static final Set<String> SERVICES = Set.of(IModFileCandidateLocator.class.getName(), IModFileReader.class.getName(), IDependencyLocator.class.getName(), GraphicsBootstrapper.class.getName(), ImmediateWindowProvider.class.getName());

    private EarlyServiceDiscovery() {
    }

    public static List<Path> findEarlyServices(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return List.of();
        }
        long start = System.currentTimeMillis();
        final ArrayList candidates = new ArrayList();
        try {
            Files.walkFileTree(directory, Set.of(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().endsWith(".jar") && attrs.isRegularFile() && attrs.size() > 0L) {
                        candidates.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new FatalStartupException("Failed to find early startup services: " + String.valueOf(e));
        }
        List<Path> earlyServices = candidates.parallelStream().filter(EarlyServiceDiscovery::shouldLoadInServiceLayer).toList();
        LOGGER.info("Found {} early service jars (out of {}) in {}ms", (Object)earlyServices.size(), (Object)candidates.size(), (Object)(System.currentTimeMillis() - start));
        return earlyServices;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean shouldLoadInServiceLayer(Path path) {
        try (JarFile jarFile = new JarFile(path.toFile(), false, 1);){
            String service;
            Iterator<String> iterator = SERVICES.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (jarFile.getEntry("META-INF/services/" + (service = iterator.next())) == null);
            LOGGER.debug("{} contains early service {}", (Object)path, (Object)service);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read Jar file {} in mods directory: {}", (Object)path, (Object)e);
        }
        return false;
    }
}

