/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;
import net.neoforged.fml.classloading.Jar;
import net.neoforged.fml.classloading.JarMetadata;
import net.neoforged.fml.jarcontents.JarContents;
import org.jetbrains.annotations.Nullable;

public interface SecureJar {
    public static SecureJar from(Path ... paths) throws IOException {
        return SecureJar.from(JarContents.ofPaths(List.of(paths)));
    }

    public static SecureJar from(JarContents contents) {
        return SecureJar.from(contents, JarMetadata.from(contents));
    }

    public static SecureJar from(JarContents contents, JarMetadata metadata) {
        return new Jar(contents, metadata);
    }

    public JarContents contents();

    public ModuleDataProvider moduleDataProvider();

    public Path getPrimaryPath();

    public String name();

    public void close() throws IOException;

    public static interface ModuleDataProvider {
        public String name();

        public ModuleDescriptor descriptor();

        @Nullable
        public URI uri();

        public Optional<URI> findFile(String var1);

        public Optional<InputStream> open(String var1);

        public Manifest getManifest();
    }
}

