/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.ByteBuffer;
import net.neoforged.fml.classloading.LazyJarMetadata;
import net.neoforged.fml.classloading.ModuleDescriptorFactory;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import org.jetbrains.annotations.Nullable;

public class ModuleJarMetadata
extends LazyJarMetadata {
    private final byte[] originalDescriptorBytes;
    private final ModuleDescriptor originalDescriptor;
    private final JarContents jar;

    public ModuleJarMetadata(JarResource moduleInfo, JarContents jar) {
        this.jar = jar;
        try {
            this.originalDescriptorBytes = moduleInfo.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read module-info.class from " + String.valueOf(moduleInfo), e);
        }
        this.originalDescriptor = ModuleDescriptor.read(ByteBuffer.wrap(this.originalDescriptorBytes));
    }

    @Override
    protected ModuleDescriptor computeDescriptor() {
        ModuleDescriptor fullDescriptor = ModuleDescriptor.read(ByteBuffer.wrap(this.originalDescriptorBytes), () -> ModuleDescriptorFactory.scanModulePackages(this.jar));
        ModuleDescriptor.Builder builder = ModuleDescriptor.newAutomaticModule(fullDescriptor.name());
        fullDescriptor.rawVersion().ifPresent(builder::version);
        builder.packages(fullDescriptor.packages());
        fullDescriptor.provides().forEach(builder::provides);
        return builder.build();
    }

    @Override
    public String name() {
        return this.originalDescriptor.name();
    }

    @Override
    @Nullable
    public String version() {
        return this.originalDescriptor.rawVersion().orElse(null);
    }
}

