/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import java.util.jar.Manifest;
import net.neoforged.fml.classloading.JarMetadata;
import net.neoforged.fml.classloading.SecureJar;
import net.neoforged.fml.jarcontents.JarContents;

public class Jar
implements SecureJar {
    private final JarContents contents;
    private final JarModuleDataProvider moduleDataProvider;
    private final JarMetadata metadata;

    public Jar(JarContents contents, JarMetadata metadata) {
        this.contents = contents;
        this.moduleDataProvider = new JarModuleDataProvider(this);
        this.metadata = metadata;
    }

    public ModuleDescriptor computeDescriptor() {
        try {
            return this.metadata.descriptor();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute the module descriptor for " + String.valueOf(this.contents), e);
        }
    }

    @Override
    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleDataProvider;
    }

    @Override
    public Path getPrimaryPath() {
        return this.contents.getPrimaryPath();
    }

    @Override
    public JarContents contents() {
        return this.contents;
    }

    public Optional<URI> findFile(String name) {
        return this.contents.findFile(name);
    }

    @Override
    public String name() {
        return this.metadata.name();
    }

    @Override
    public void close() throws IOException {
        this.contents.close();
    }

    public String toString() {
        return "Jar[" + String.valueOf(this.getPrimaryPath()) + "]";
    }

    private record JarModuleDataProvider(Jar jar) implements SecureJar.ModuleDataProvider
    {
        @Override
        public String name() {
            return this.jar.name();
        }

        @Override
        public ModuleDescriptor descriptor() {
            return this.jar.computeDescriptor();
        }

        @Override
        public URI uri() {
            return this.jar.getPrimaryPath().toUri();
        }

        @Override
        public Optional<URI> findFile(String name) {
            return this.jar.findFile(name);
        }

        @Override
        public Optional<InputStream> open(String name) {
            try {
                return Optional.ofNullable(this.jar.contents.openFile(name));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open " + name, e);
            }
        }

        @Override
        public Manifest getManifest() {
            return this.jar.contents.getManifest();
        }
    }
}

