/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeElement;
import net.neoforged.fml.earlydisplay.util.Bounds;
import net.neoforged.fml.earlydisplay.util.StyleLength;
import org.jetbrains.annotations.Nullable;

public abstract class RenderElement
implements AutoCloseable {
    protected final MaterializedTheme theme;
    @Nullable
    private String id;
    protected SimpleFont font;
    private final ThemeElement element;

    public RenderElement(ThemeElement element, MaterializedTheme theme) {
        this.theme = theme;
        this.font = theme.getFont(element.font());
        this.element = element;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public abstract void render(RenderContext var1);

    public Bounds resolveBounds(float availableWidth, float availableHeight, float intrinsicWidth, float intrinsicHeight) {
        boolean heightDefined;
        float left = this.resolve(this.element.left(), availableWidth);
        float right = availableWidth - this.resolve(this.element.right(), availableWidth);
        float top = this.resolve(this.element.top(), availableHeight);
        float bottom = availableHeight - this.resolve(this.element.bottom(), availableHeight);
        float width = right - left;
        float height = bottom - top;
        boolean widthDefined = !Float.isNaN(width);
        boolean bl = heightDefined = !Float.isNaN(height);
        if (widthDefined != heightDefined) {
            if (this.element.maintainAspectRatio()) {
                float ar = intrinsicWidth / intrinsicHeight;
                if (widthDefined) {
                    height = width / ar;
                } else {
                    width = height * ar;
                }
            } else if (widthDefined) {
                height = intrinsicHeight;
            } else if (heightDefined) {
                width = intrinsicWidth;
            }
        } else if (!widthDefined && !heightDefined) {
            width = intrinsicWidth;
            height = intrinsicHeight;
        }
        if (Float.isNaN(left) && Float.isNaN(right)) {
            left = 0.0f;
            right = width;
        } else if (Float.isNaN(right)) {
            right = left + width;
        } else if (Float.isNaN(left)) {
            left = right - width;
        }
        if (Float.isNaN(top) && Float.isNaN(bottom)) {
            top = 0.0f;
            bottom = height;
        } else if (Float.isNaN(bottom)) {
            bottom = top + height;
        } else if (Float.isNaN(top)) {
            top = bottom - height;
        }
        if (this.element.centerHorizontally()) {
            width = right - left;
            left = availableWidth / 2.0f - width / 2.0f + left;
            right = left + width;
        }
        if (this.element.centerVertically()) {
            height = bottom - top;
            top = availableHeight / 2.0f - height / 2.0f + top;
            bottom = top + height;
        }
        return new Bounds(left, top, right, bottom);
    }

    private float resolve(StyleLength length, float availableSpace) {
        return switch (length.unit()) {
            default -> throw new MatchException(null, null);
            case StyleLength.Unit.UNDEFINED -> Float.NaN;
            case StyleLength.Unit.POINT -> length.value();
            case StyleLength.Unit.REM -> length.value() * (float)this.font.lineSpacing();
            case StyleLength.Unit.PERCENT -> length.value() * availableSpace / 100.0f;
        };
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    public static int clamp(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.id;
    }
}

