/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import net.neoforged.fml.earlydisplay.GlDebug;
import net.neoforged.fml.earlydisplay.GlState;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;

public class STBHelper {
    public static ByteBuffer readFromClasspath(String name, int initialCapacity) {
        ByteBuffer buf;
        try (ReadableByteChannel channel = Channels.newChannel(Objects.requireNonNull(STBHelper.class.getClassLoader().getResourceAsStream(name), "The resource " + name + " cannot be found"));){
            int readbytes;
            buf = BufferUtils.createByteBuffer((int)initialCapacity);
            while ((readbytes = channel.read(buf)) != -1) {
                if (buf.remaining() != 0) continue;
                ByteBuffer newBuf = BufferUtils.createByteBuffer((int)(buf.capacity() * 3 / 2));
                buf.flip();
                newBuf.put(buf);
                buf = newBuf;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        buf.flip();
        return MemoryUtil.memSlice((ByteBuffer)buf);
    }

    public static ImageTexture loadTextureFromClasspath(String file, int size) {
        int[] lw = new int[1];
        int[] lh = new int[1];
        int[] lc = new int[1];
        ByteBuffer img = STBHelper.loadImageFromClasspath(file, size, lw, lh, lc);
        int texid = GL32C.glGenTextures();
        GlState.activeTexture(33984);
        GlState.bindTexture2D(texid);
        GlDebug.labelTexture(texid, "EarlyDisplay " + file);
        GL32C.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL32C.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32C.glTexImage2D((int)3553, (int)0, (int)6408, (int)lw[0], (int)lh[0], (int)0, (int)6408, (int)5121, (ByteBuffer)img);
        GlState.activeTexture(33984);
        MemoryUtil.memFree((Buffer)img);
        return new ImageTexture(texid, new int[]{lw[0], lh[0]});
    }

    public static ByteBuffer loadImageFromClasspath(String file, int size, int[] width, int[] height, int[] channels) {
        ByteBuffer buf = STBHelper.readFromClasspath(file, size);
        return STBImage.stbi_load_from_memory((ByteBuffer)buf, (int[])width, (int[])height, (int[])channels, (int)4);
    }

    public record ImageTexture(int textureId, int[] size) {
    }
}

