/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.ThemeColor;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeStartupLogElement;
import net.neoforged.fml.earlydisplay.util.Bounds;
import net.neoforged.fml.earlydisplay.util.Size;
import net.neoforged.fml.loading.progress.Message;
import net.neoforged.fml.loading.progress.StartupNotificationManager;

public class StartupLogElement
extends RenderElement {
    private ThemeColor textColor;

    public StartupLogElement(ThemeStartupLogElement settings, MaterializedTheme theme) {
        super(settings, theme);
        this.textColor = Objects.requireNonNullElseGet(this.textColor, () -> theme.theme().colorScheme().text());
    }

    @Override
    public void render(RenderContext context) {
        List messages = StartupNotificationManager.getMessages();
        ArrayList<SimpleFont.DisplayText> texts = new ArrayList<SimpleFont.DisplayText>();
        for (int i = messages.size() - 1; i >= 0; --i) {
            StartupNotificationManager.AgeMessage pair = (StartupNotificationManager.AgeMessage)messages.get(i);
            float fade = StartupLogElement.clamp((4000.0f - (float)pair.age() - (float)(i - 4) * 1000.0f) / 5000.0f, 0.0f, 1.0f);
            if (fade < 0.01f) continue;
            Message msg = pair.message();
            int colour = this.textColor.withAlpha(fade).toArgb();
            texts.add(new SimpleFont.DisplayText(msg.getText() + "\n", colour));
        }
        Size intrinsicSize = StartupLogElement.getIntrinsicSize(texts, this.font);
        Bounds bounds = this.resolveBounds(context.availableWidth(), context.availableHeight(), intrinsicSize.width(), intrinsicSize.height());
        context.renderText(bounds.left(), bounds.top(), this.font, texts);
    }

    private static Size getIntrinsicSize(List<SimpleFont.DisplayText> texts, SimpleFont font) {
        Bounds bounds = new Bounds(0.0f, 0.0f, 0.0f, 0.0f);
        for (SimpleFont.DisplayText text : texts) {
            bounds = bounds.union(new Bounds(0.0f, bounds.bottom(), font.measureText(text.string())));
        }
        return new Size(bounds.width(), bounds.height());
    }
}

