/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.neoforged.fml.earlydisplay.render.EarlyFramebuffer;
import net.neoforged.fml.earlydisplay.render.ElementShader;
import net.neoforged.fml.earlydisplay.render.GlDebug;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.RenderContext;
import net.neoforged.fml.earlydisplay.render.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.render.elements.ImageElement;
import net.neoforged.fml.earlydisplay.render.elements.LabelElement;
import net.neoforged.fml.earlydisplay.render.elements.MojangLogoElement;
import net.neoforged.fml.earlydisplay.render.elements.PerformanceElement;
import net.neoforged.fml.earlydisplay.render.elements.ProgressBarsElement;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.render.elements.StartupLogElement;
import net.neoforged.fml.earlydisplay.theme.Theme;
import net.neoforged.fml.earlydisplay.theme.ThemeColor;
import net.neoforged.fml.earlydisplay.theme.ThemeLoadingScreen;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeDecorativeElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeImageElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeLabelElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingScreenRenderer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingScreenRenderer.class);
    public static final int LAYOUT_WIDTH = 854;
    public static final int LAYOUT_HEIGHT = 480;
    @VisibleForTesting
    public static volatile boolean rendered = false;
    private final long glfwWindow;
    private final MaterializedTheme theme;
    private static final long MINFRAMETIME = TimeUnit.MILLISECONDS.toNanos(10L);
    private int animationFrame;
    private long nextFrameTime = 0L;
    private final EarlyFramebuffer framebuffer;
    private final Semaphore renderLock = new Semaphore(1);
    private final ScheduledFuture<?> automaticRendering;
    private final List<RenderElement> elements;
    private final SimpleBufferBuilder buffer = new SimpleBufferBuilder("shared", 8192);
    private final Supplier<String> minecraftVersion;
    private final Supplier<String> neoForgeVersion;

    public LoadingScreenRenderer(ScheduledExecutorService scheduler, long glfwWindow, Theme theme, @Nullable Path externalThemeDirectory, Supplier<String> minecraftVersion, Supplier<String> neoForgeVersion) {
        this.glfwWindow = glfwWindow;
        this.minecraftVersion = minecraftVersion;
        this.neoForgeVersion = neoForgeVersion;
        GLFW.glfwMakeContextCurrent((long)glfwWindow);
        GLFW.glfwSwapInterval((int)1);
        GLCapabilities capabilities = GL.createCapabilities();
        GlState.readFromOpenGL();
        GlDebug.setCapabilities(capabilities);
        LOGGER.info("GL info: {} GL version {}, {}", new Object[]{GL11C.glGetString((int)7937), GL11C.glGetString((int)7938), GL11C.glGetString((int)7936)});
        this.theme = MaterializedTheme.materialize(theme, externalThemeDirectory);
        this.elements = this.loadElements();
        this.framebuffer = new EarlyFramebuffer(854, 480);
        ThemeColor background = theme.colorScheme().screenBackground();
        GlState.clearColor(background.r(), background.g(), background.b(), 1.0f);
        GL32C.glClear((int)16384);
        GlState.enableBlend(true);
        GlState.blendFuncSeparate(770, 771, 770, 771);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.automaticRendering = scheduler.scheduleWithFixedDelay(this::renderToScreen, 50L, 50L, TimeUnit.MILLISECONDS);
        scheduler.scheduleWithFixedDelay(() -> ++this.animationFrame, 1L, 50L, TimeUnit.MILLISECONDS);
    }

    private List<RenderElement> loadElements() {
        ArrayList<RenderElement> elements = new ArrayList<RenderElement>();
        ThemeLoadingScreen loadingScreen = this.theme.theme().loadingScreen();
        if (loadingScreen.performance().visible()) {
            elements.add(new PerformanceElement(loadingScreen.performance(), this.theme));
        }
        if (loadingScreen.startupLog().visible()) {
            elements.add(new StartupLogElement(loadingScreen.startupLog(), this.theme));
        }
        if (loadingScreen.progressBars().visible()) {
            elements.add(new ProgressBarsElement(loadingScreen.progressBars(), this.theme));
        }
        if (loadingScreen.mojangLogo().visible()) {
            elements.add(new MojangLogoElement(loadingScreen.mojangLogo(), this.theme));
        }
        for (Map.Entry<String, ThemeDecorativeElement> entry : loadingScreen.decoration().entrySet()) {
            ThemeDecorativeElement element = entry.getValue();
            if (!element.visible()) continue;
            elements.add(this.loadElement(entry.getKey(), element));
        }
        return elements;
    }

    private RenderElement loadElement(String id, ThemeElement element) {
        ThemeElement themeElement = element;
        Objects.requireNonNull(themeElement);
        ThemeElement themeElement2 = themeElement;
        int n = 0;
        RenderElement renderElement = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ThemeImageElement.class, ThemeLabelElement.class}, (Object)themeElement2, n)) {
            case 0 -> {
                ThemeImageElement imageElement = (ThemeImageElement)themeElement2;
                yield new ImageElement(imageElement, this.theme);
            }
            case 1 -> {
                ThemeLabelElement labelElement = (ThemeLabelElement)themeElement2;
                yield new LabelElement(labelElement, this.theme, () -> Map.of("version", this.getVersionString()));
            }
            default -> throw new IllegalStateException("Unexpected theme element " + String.valueOf(element) + " of type " + String.valueOf(element.getClass()));
        };
        renderElement.setId(id);
        return renderElement;
    }

    private String getVersionString() {
        String neoForgeVersion;
        StringBuilder result = new StringBuilder();
        String minecraftVersion = this.minecraftVersion.get();
        if (minecraftVersion != null) {
            result.append(minecraftVersion);
        }
        if ((neoForgeVersion = this.neoForgeVersion.get()) != null) {
            if (!result.isEmpty()) {
                result.append("-");
            }
            result.append(neoForgeVersion.split("-")[0]);
        }
        return result.toString();
    }

    public void stopAutomaticRendering() throws TimeoutException, InterruptedException {
        this.automaticRendering.cancel(false);
        if (!this.renderLock.tryAcquire(5L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        this.renderLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderToScreen() {
        if (!this.renderLock.tryAcquire()) {
            return;
        }
        try {
            long nt = System.nanoTime();
            if (nt < this.nextFrameTime) {
                return;
            }
            this.nextFrameTime = nt + MINFRAMETIME;
            GLFW.glfwMakeContextCurrent((long)this.glfwWindow);
            GlState.readFromOpenGL();
            GlState.StateSnapshot backup = GlState.createSnapshot();
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetFramebufferSize((long)this.glfwWindow, (int[])w, (int[])h);
            this.framebuffer.resize(w[0], h[0]);
            this.renderToFramebuffer();
            GlState.viewport(0, 0, w[0], h[0]);
            this.framebuffer.blitToScreen(this.theme.theme().colorScheme().screenBackground(), w[0], h[0]);
            GLFW.glfwSwapBuffers((long)this.glfwWindow);
            GlState.applySnapshot(backup);
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error while rendering the loading screen", t);
        }
        finally {
            if (this.automaticRendering != null) {
                GLFW.glfwMakeContextCurrent((long)0L);
            }
            this.renderLock.release();
            rendered = true;
        }
    }

    public void renderToFramebuffer() {
        GlDebug.pushGroup("update EarlyDisplay framebuffer");
        GlState.readFromOpenGL();
        GlState.StateSnapshot backup = GlState.createSnapshot();
        this.framebuffer.activate();
        float desiredAspectRatio = 1.7791667f;
        float actualAspectRatio = (float)this.framebuffer.width() / (float)this.framebuffer.height();
        if (actualAspectRatio > desiredAspectRatio) {
            float actualWidth = desiredAspectRatio * (float)this.framebuffer.height();
            GlState.viewport((int)((float)this.framebuffer.width() - actualWidth) / 2, 0, (int)actualWidth, this.framebuffer.height());
        } else {
            float actualHeight = (float)this.framebuffer.width() / desiredAspectRatio;
            GlState.viewport(0, (int)((float)this.framebuffer.height() - actualHeight) / 2, this.framebuffer.width(), (int)actualHeight);
        }
        ThemeColor background = this.theme.theme().colorScheme().screenBackground();
        GlState.clearColor(background.r(), background.g(), background.b(), 1.0f);
        GL11C.glClear((int)16640);
        GlState.enableBlend(true);
        GlState.blendFuncSeparate(770, 771, 0, 1);
        for (ElementShader shader : this.theme.shaders().values()) {
            shader.activate();
            if (!shader.hasUniform("screenSize")) continue;
            shader.setUniform2f("screenSize", 854.0f, 480.0f);
        }
        RenderContext context = new RenderContext(this.buffer, this.theme, 854.0f, 480.0f, this.animationFrame);
        for (RenderElement element : this.elements) {
            element.render(context);
        }
        this.framebuffer.deactivate();
        GlState.applySnapshot(backup);
        GlDebug.popGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        long previousContext = GLFW.glfwGetCurrentContext();
        GLCapabilities previousCaps = GL.getCapabilities();
        boolean needsToRestoreContext = false;
        if (previousContext != this.glfwWindow) {
            GLFW.glfwMakeContextCurrent((long)this.glfwWindow);
            GL.createCapabilities();
            needsToRestoreContext = true;
        }
        try {
            this.theme.close();
            for (RenderElement element : this.elements) {
                element.close();
            }
            this.framebuffer.close();
            this.buffer.close();
            SimpleBufferBuilder.destroy();
        }
        finally {
            if (needsToRestoreContext) {
                GLFW.glfwMakeContextCurrent((long)previousContext);
                GL.setCapabilities((GLCapabilities)previousCaps);
            }
        }
    }

    public int getFramebufferTextureId() {
        return this.framebuffer.getTexture();
    }
}

