/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract sealed class FileOpener {
    private static final Logger LOGGER = LogManager.getLogger();

    FileOpener() {
    }

    static FileOpener get() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.contains("win")) {
            return new Windows();
        }
        if (osName.contains("mac")) {
            return new Mac();
        }
        return new Default();
    }

    final void open(Path path) {
        URI uri = path.toUri();
        try {
            Runtime.getRuntime().exec(this.getOpenParameters(uri));
        }
        catch (IOException e) {
            LOGGER.error("Failed to open URI '{}'", (Object)uri, (Object)e);
        }
    }

    protected abstract String[] getOpenParameters(URI var1);

    private static final class Windows
    extends FileOpener {
        private Windows() {
        }

        @Override
        protected String[] getOpenParameters(URI uri) {
            return new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()};
        }
    }

    private static final class Mac
    extends FileOpener {
        private Mac() {
        }

        @Override
        protected String[] getOpenParameters(URI uri) {
            return new String[]{"open", uri.toString()};
        }
    }

    private static final class Default
    extends FileOpener {
        private Default() {
        }

        @Override
        protected String[] getOpenParameters(URI uri) {
            String uriString = uri.toString();
            if ("file".equals(uri.getScheme())) {
                uriString = uriString.replace("file:", "file://");
            }
            return new String[]{"xdg-open", uriString};
        }
    }
}

