/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.coremod.api;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.INameMappingService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import javax.script.ScriptException;
import net.neoforged.coremod.CoreModTracker;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ASMAPI {
    public static MethodNode getMethodNode() {
        return new MethodNode(393216);
    }

    public static void appendMethodCall(MethodNode node, MethodInsnNode methodCall) {
        node.instructions.insertBefore(node.instructions.getFirst(), (AbstractInsnNode)methodCall);
    }

    public static MethodInsnNode buildMethodCall(String ownerName, String methodName, String methodDescriptor, MethodType type) {
        return new MethodInsnNode(type.toOpcode(), ownerName, methodName, methodDescriptor, type == MethodType.INTERFACE);
    }

    public static String mapMethod(String name) {
        return ASMAPI.map(name, INameMappingService.Domain.METHOD);
    }

    public static String mapField(String name) {
        return ASMAPI.map(name, INameMappingService.Domain.FIELD);
    }

    private static String map(String name, INameMappingService.Domain domain) {
        return Optional.ofNullable(Launcher.INSTANCE).map(Launcher::environment).flatMap(env -> env.findNameMapping("srg")).map(f -> (String)f.apply(domain, name)).orElse(name);
    }

    public static boolean getSystemPropertyFlag(String propertyName) {
        return Boolean.getBoolean(System.getProperty("coremod." + propertyName, "TRUE"));
    }

    public static AbstractInsnNode findFirstInstruction(MethodNode method, int opCode) {
        return ASMAPI.findFirstInstructionAfter(method, opCode, 0);
    }

    public static AbstractInsnNode findFirstInstructionAfter(MethodNode method, int opCode, int startIndex) {
        for (int i = Math.max(0, startIndex); i < method.instructions.size(); ++i) {
            AbstractInsnNode ain = method.instructions.get(i);
            if (ain.getOpcode() != opCode) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opCode, int startIndex) {
        for (int i = Math.max(method.instructions.size() - 1, startIndex); i >= 0; --i) {
            AbstractInsnNode ain = method.instructions.get(i);
            if (ain.getOpcode() != opCode) continue;
            return ain;
        }
        return null;
    }

    public static MethodInsnNode findFirstMethodCall(MethodNode method, MethodType type, String owner, String name, String descriptor) {
        return ASMAPI.findFirstMethodCallAfter(method, type, owner, name, descriptor, 0);
    }

    public static MethodInsnNode findFirstMethodCallAfter(MethodNode method, MethodType type, String owner, String name, String descriptor, int startIndex) {
        for (int i = Math.max(0, startIndex); i < method.instructions.size(); ++i) {
            AbstractInsnNode node = method.instructions.get(i);
            if (!(node instanceof MethodInsnNode) || node.getOpcode() != type.toOpcode()) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(descriptor)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findFirstMethodCallBefore(MethodNode method, MethodType type, String owner, String name, String descriptor, int startIndex) {
        for (int i = Math.min(method.instructions.size() - 1, startIndex); i >= 0; --i) {
            AbstractInsnNode node = method.instructions.get(i);
            if (!(node instanceof MethodInsnNode) || node.getOpcode() != type.toOpcode()) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(descriptor)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static boolean insertInsnList(MethodNode method, MethodType type, String owner, String name, String desc, InsnList list, InsertMode mode) {
        ListIterator nodeIterator = method.instructions.iterator();
        int opcode = type.toOpcode();
        while (nodeIterator.hasNext()) {
            AbstractInsnNode next = (AbstractInsnNode)nodeIterator.next();
            if (next.getOpcode() != opcode) continue;
            MethodInsnNode castedNode = (MethodInsnNode)next;
            if (!castedNode.owner.equals(owner) || !castedNode.name.equals(name) || !castedNode.desc.equals(desc)) continue;
            if (mode == InsertMode.INSERT_BEFORE) {
                method.instructions.insertBefore(next, list);
            } else {
                method.instructions.insert(next, list);
            }
            if (mode == InsertMode.REMOVE_ORIGINAL) {
                nodeIterator.remove();
            }
            return true;
        }
        return false;
    }

    public static InsnList listOf(AbstractInsnNode ... nodes) {
        InsnList list = new InsnList();
        for (AbstractInsnNode node : nodes) {
            list.add(node);
        }
        return list;
    }

    public static void redirectFieldToMethod(ClassNode classNode, String fieldName, @Nullable String methodName) {
        MethodNode foundMethod = null;
        FieldNode foundField = null;
        for (FieldNode fieldNode : classNode.fields) {
            if (!Objects.equals(fieldNode.name, fieldName)) continue;
            if (foundField == null) {
                foundField = fieldNode;
                continue;
            }
            throw new IllegalStateException("Found multiple fields with name " + fieldName);
        }
        if (foundField == null) {
            throw new IllegalStateException("No field with name " + fieldName + " found");
        }
        if (!Modifier.isPrivate(foundField.access) || Modifier.isStatic(foundField.access)) {
            throw new IllegalStateException("Field " + fieldName + " is not private and an instance field");
        }
        String methodSignature = "()" + foundField.desc;
        for (MethodNode methodNode : classNode.methods) {
            if (!Objects.equals(methodNode.desc, methodSignature)) continue;
            if (foundMethod == null && Objects.equals(methodNode.name, methodName)) {
                foundMethod = methodNode;
                continue;
            }
            if (foundMethod == null && methodName == null) {
                foundMethod = methodNode;
                continue;
            }
            if (foundMethod == null || methodName != null && !Objects.equals(methodNode.name, methodName)) continue;
            throw new IllegalStateException("Found duplicate method with signature " + methodSignature);
        }
        if (foundMethod == null) {
            throw new IllegalStateException("Unable to find method " + methodSignature);
        }
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode == foundMethod || Objects.equals(methodNode.desc, methodSignature)) continue;
            ListIterator iterator = methodNode.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                if (insnNode.getOpcode() != 180) continue;
                FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
                if (!Objects.equals(fieldInsnNode.name, fieldName)) continue;
                iterator.remove();
                MethodInsnNode replace = new MethodInsnNode(182, classNode.name, foundMethod.name, foundMethod.desc, false);
                iterator.add(replace);
            }
        }
    }

    public static boolean loadFile(String file) throws ScriptException, IOException {
        return CoreModTracker.loadFileByName(file);
    }

    @Nullable
    public static Object loadData(String file) throws ScriptException, IOException {
        return CoreModTracker.loadDataByName(file);
    }

    public static void log(String level, String message, Object ... args) {
        CoreModTracker.log(level, message, args);
    }

    public static String classNodeToString(ClassNode node) {
        Textifier text = new Textifier();
        node.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)text, null));
        return ASMAPI.toString(text);
    }

    public static String fieldNodeToString(FieldNode node) {
        Textifier text = new Textifier();
        node.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)text, null));
        return ASMAPI.toString(text);
    }

    public static String methodNodeToString(MethodNode node) {
        Textifier text = new Textifier();
        node.accept((MethodVisitor)new TraceMethodVisitor((Printer)text));
        return ASMAPI.toString(text);
    }

    private static String toString(Textifier text) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        text.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static enum MethodType {
        VIRTUAL,
        SPECIAL,
        STATIC,
        INTERFACE;


        public int toOpcode() {
            return 182 + this.ordinal();
        }
    }

    public static enum InsertMode {
        REMOVE_ORIGINAL,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

