/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.bus;

import java.lang.annotation.Annotation;
import net.neoforged.bus.LockHelper;
import net.neoforged.bus.api.Event;

public class EventListenerHelper {
    private static final LockHelper<Class<?>, Boolean> hasResult = LockHelper.withIdentityHashMap();

    public static boolean hasResult(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Event.HasResult.class, hasResult);
    }

    private static boolean hasAnnotation(Class<?> eventClass, Class<? extends Annotation> annotation, LockHelper<Class<?>, Boolean> lock) {
        if (eventClass == Event.class) {
            return false;
        }
        Boolean result = lock.get(eventClass);
        if (result != null) {
            return result;
        }
        return lock.computeIfAbsent(eventClass, e -> {
            Class parent = eventClass.getSuperclass();
            return eventClass.isAnnotationPresent(annotation) || parent != null && EventListenerHelper.hasAnnotation(parent, annotation, lock);
        });
    }
}

