/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;

public final class AtParser {
    private AtParser() {
    }

    public static void parse(Reader wrappedReader, String originName, BiConsumer<Target, Transformation> consumer) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(wrappedReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                Record target;
                StringBuilder builder = new StringBuilder();
                ArrayList<String> parts = new ArrayList<String>();
                builder.setLength(0);
                for (char c : line.toCharArray()) {
                    if (Character.isWhitespace(c)) {
                        if (!builder.isEmpty()) {
                            parts.add(builder.toString());
                        }
                        builder.setLength(0);
                        continue;
                    }
                    if (c == '#') {
                        builder.setLength(0);
                        break;
                    }
                    builder.appendCodePoint(c);
                }
                if (!builder.isEmpty()) {
                    parts.add(builder.toString());
                }
                if (parts.isEmpty()) continue;
                if (parts.size() < 2) {
                    throw new RuntimeException("Invalid line " + reader.getLineNumber() + "; should be '<modifier> <class name> [<member>]'");
                }
                String modifierString = (String)parts.get(0);
                Transformation.FinalState finalState = Transformation.FinalState.LEAVE;
                if (modifierString.endsWith("-f")) {
                    finalState = Transformation.FinalState.REMOVEFINAL;
                    modifierString = modifierString.substring(0, modifierString.length() - 2);
                } else if (modifierString.endsWith("+f")) {
                    finalState = Transformation.FinalState.MAKEFINAL;
                    modifierString = modifierString.substring(0, modifierString.length() - 2);
                }
                Transformation.Modifier modifier = AtParser.parseModifier(modifierString, reader.getLineNumber());
                String className = (String)parts.get(1);
                if (className.chars().reduce(0, (last, current) -> {
                    if (last == 0 && !Character.isJavaIdentifierStart(current) || last != 0 && current != 46 && !Character.isJavaIdentifierPart(current)) {
                        throw new RuntimeException("Invalid class name '" + className + "' at line " + reader.getLineNumber());
                    }
                    return current == 46 ? 0 : 1;
                }) != 1) {
                    throw new RuntimeException("Invalid class name '" + className + "' at line " + reader.getLineNumber());
                }
                Transformation transformation = new Transformation(modifier, finalState, originName, reader.getLineNumber());
                if (parts.size() < 3) {
                    target = new Target.ClassTarget(className);
                    AtParser.locateInnerClassAts(className, transformation, consumer);
                } else {
                    String member = (String)parts.get(2);
                    if (member.equals("*")) {
                        target = new Target.WildcardFieldTarget(className);
                    } else if (member.equals("*()")) {
                        target = new Target.WildcardMethodTarget(className);
                    } else if (member.contains("(")) {
                        String name = member.substring(0, member.indexOf(40));
                        String desc = member.substring(member.indexOf(40)).replace('.', '/');
                        AtParser.validateMethodDescriptor(desc, reader.getLineNumber());
                        if (!name.equals("<init>")) {
                            AtParser.validateIdentifier(name, "method", reader.getLineNumber());
                        }
                        target = new Target.MethodTarget(className, name, desc);
                    } else {
                        AtParser.validateIdentifier(member, "field", reader.getLineNumber());
                        target = new Target.FieldTarget(className, member);
                    }
                }
                consumer.accept((Target)((Object)target), transformation);
            }
        }
    }

    private static Transformation.Modifier parseModifier(String modifier, int line) {
        return switch (modifier) {
            case "public" -> Transformation.Modifier.PUBLIC;
            case "private" -> Transformation.Modifier.PRIVATE;
            case "protected" -> Transformation.Modifier.PROTECTED;
            case "default" -> Transformation.Modifier.DEFAULT;
            default -> throw new RuntimeException("Invalid modifier: " + modifier + " at line " + line);
        };
    }

    private static void locateInnerClassAts(String className, Transformation transformation, BiConsumer<Target, Transformation> consumer) {
        int split = className.lastIndexOf(36);
        if (split == -1) {
            return;
        }
        String parent = className.substring(0, split);
        consumer.accept(new Target.InnerClassTarget(parent, className), transformation);
    }

    private static void validateMethodDescriptor(String desc, int index) {
        int open = desc.indexOf(40);
        int close = desc.lastIndexOf(41);
        String error = "Invalid method descriptor '" + desc + "' at line " + index;
        if (open != 0 || close == -1) {
            throw new RuntimeException(error);
        }
        String argsTypes = desc.substring(open + 1, close);
        String returnType = desc.substring(close + 1);
        if (AtParser.validateDescriptor(returnType, true, error) != 1) {
            throw new RuntimeException(error);
        }
        AtParser.validateDescriptor(argsTypes, false, error);
    }

    private static int validateDescriptor(String types, boolean allowVoid, String error) {
        int count = 0;
        boolean inArray = false;
        for (int idx = 0; idx < types.length(); ++idx) {
            char c = types.charAt(idx);
            if (c == 'V' && (!allowVoid || inArray)) {
                throw new RuntimeException(error);
            }
            if ("ZCBSIFJDV".indexOf(c) != -1) {
                inArray = false;
                ++count;
                continue;
            }
            if (c == '[') {
                inArray = true;
                continue;
            }
            if (c == 'L') {
                int end = types.indexOf(59, idx);
                if (end == -1) {
                    throw new RuntimeException(error);
                }
                String full = types.substring(idx + 1, end);
                if (full.chars().anyMatch(i -> ".[".indexOf(i) != -1)) {
                    throw new RuntimeException(error);
                }
                ++count;
                inArray = false;
                idx = end;
                continue;
            }
            throw new RuntimeException(error);
        }
        if (inArray) {
            throw new RuntimeException(error);
        }
        return count;
    }

    private static void validateIdentifier(String name, String sort, int index) {
        if (!Character.isJavaIdentifierStart(name.charAt(0)) || name.chars().skip(1L).anyMatch(c -> !Character.isJavaIdentifierPart(c))) {
            throw new RuntimeException("Invalid " + sort + "name '" + name + "' at line " + index);
        }
    }
}

