/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.relocated.net.neoforged.cliutils.progress;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLConnection;
import java.text.DecimalFormat;
import net.minecraftforge.fart.relocated.net.neoforged.cliutils.progress.ProgressActionType;
import net.minecraftforge.fart.relocated.net.neoforged.cliutils.progress.ProgressManager;

public class ProgressReporter
implements ProgressManager {
    public static final String MODIFIER_KEY = "progressmanager";
    public static final String ENABLED_PROPERTY = "net.neoforged.progressmanager.enabled";
    private static final DecimalFormat TWO_DECIMALS = new DecimalFormat("#.00");
    protected final boolean enabled;
    protected final PrintStream output;

    public ProgressReporter(boolean enabled, PrintStream output) {
        this.enabled = enabled;
        this.output = output;
    }

    public static ProgressReporter getDefault() {
        return new ProgressReporter(Boolean.getBoolean(ENABLED_PROPERTY), System.err);
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.write(ProgressActionType.MAX_PROGRESS, String.valueOf(maxProgress));
    }

    @Override
    public void setProgress(int progress) {
        this.write(ProgressActionType.PROGRESS, String.valueOf(progress));
    }

    @Override
    public void setPercentageProgress(double progress) {
        this.write(ProgressActionType.PROGRESS, TWO_DECIMALS.format(progress) + "%");
    }

    @Override
    public void setStep(String name) {
        this.write(ProgressActionType.STEP, name);
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.write(ProgressActionType.INDETERMINATE, String.valueOf(indeterminate));
    }

    protected void write(ProgressActionType type, String value) {
        if (!this.enabled) {
            return;
        }
        try {
            this.output.println(String.format("\u001b[%s;%s %s", MODIFIER_KEY, Character.valueOf(type.identifier), value));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.err.println("Failed to write progress: " + exception);
        }
    }

    public InputStream wrapDownload(URLConnection connection) throws IOException {
        connection.connect();
        this.setMaxProgress(connection.getContentLength());
        return this.wrapDownload(connection.getInputStream());
    }

    public InputStream wrapDownload(InputStream in) {
        return new FilterInputStream(in){
            private int nread;
            {
                this.nread = 0;
            }

            @Override
            public int read() throws IOException {
                int c = this.in.read();
                if (c >= 0) {
                    ProgressReporter.this.setProgress(++this.nread);
                }
                return c;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int nr = this.in.read(b);
                if (nr > 0) {
                    ProgressReporter.this.setProgress(this.nread += nr);
                }
                return nr;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int nr = this.in.read(b, off, len);
                if (nr > 0) {
                    ProgressReporter.this.setProgress(this.nread += nr);
                }
                return nr;
            }

            @Override
            public long skip(long n) throws IOException {
                long nr = this.in.skip(n);
                if (nr > 0L) {
                    this.nread = (int)((long)this.nread + nr);
                    ProgressReporter.this.setProgress(this.nread);
                }
                return nr;
            }
        };
    }
}

