/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.relocated.net.neoforged.cliutils.progress;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fart.relocated.net.neoforged.cliutils.progress.ProgressActionType;
import net.minecraftforge.fart.relocated.net.neoforged.cliutils.progress.ProgressManager;

public class ProgressInterceptor
extends FilterOutputStream {
    public static final String FULL_MODIFIER = "\u001b[progressmanager;";
    protected final ProgressManager manager;
    private StringBuffer current;

    public ProgressInterceptor(OutputStream out, ProgressManager manager) {
        super(out);
        this.manager = manager;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.current != null) {
            if (b == 10) {
                this.processCurrent();
            } else if (b != 13) {
                this.current.append((char)b);
            }
        } else if (b == 27) {
            this.current = new StringBuffer().append((char)b);
        } else {
            this.out.write(b);
        }
    }

    private void processCurrent() throws IOException {
        String cur = this.current.toString();
        if (cur.startsWith(FULL_MODIFIER)) {
            String[] values = cur.substring(FULL_MODIFIER.length()).split(" ", 2);
            if (values.length == 2) {
                String first = values[0];
                if (first.length() != 1) {
                    System.err.println("Invalid progress modifier: " + values[0]);
                    return;
                }
                ProgressActionType action = ProgressActionType.TYPES.get(Character.valueOf(first.charAt(0)));
                if (action == null) {
                    System.err.println("Unknown progress modifier: " + first.charAt(0));
                    return;
                }
                action.acceptor.accept(this.manager, values[1]);
            }
        } else {
            this.out.write(cur.getBytes(StandardCharsets.UTF_8));
            this.out.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
        }
        this.current = null;
    }
}

