/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.ManifestVerifier;
import cpw.mods.jarhandling.impl.SecureJarVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Jar
implements SecureJar {
    private static final CodeSigner[] EMPTY_CODESIGNERS = new CodeSigner[0];
    private static final FileSystemProvider UFSP = FileSystemProvider.installedProviders().stream().filter(p -> "union".equalsIgnoreCase(p.getScheme())).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));
    private final Manifest manifest;
    private final Hashtable<String, CodeSigner[]> pendingSigners = new Hashtable();
    private final Hashtable<String, CodeSigner[]> verifiedSigners = new Hashtable();
    private final ManifestVerifier verifier = new ManifestVerifier();
    private final Map<String, StatusData> statusData = new HashMap<String, StatusData>();
    private final JarMetadata metadata;
    private final Path filesystemRoot;
    private final Path filesystemPrimary;
    private final Map<String, String> nameOverrides;
    private final JarModuleDataProvider moduleDataProvider;
    private final Set<String> packages;
    private final List<SecureJar.Provider> providers;

    @Override
    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleDataProvider;
    }

    @Override
    public Path getPrimaryPath() {
        return this.filesystemPrimary;
    }

    public Jar(Function<SecureJar, JarMetadata> metadataFunction, BiPredicate<String, String> pathfilter, Path ... paths) {
        this(null, metadataFunction, pathfilter, paths);
    }

    @Deprecated(forRemoval=true, since="2.2")
    public Jar(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataFunction, BiPredicate<String, String> pathfilter, Path ... paths) {
        Path[] validPaths = (Path[])Arrays.stream(paths).map(Path::toAbsolutePath).map(Path::normalize).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toArray(Path[]::new);
        if (validPaths.length == 0) {
            throw new UncheckedIOException(new IOException("Invalid paths argument, contained no existing paths: " + Arrays.toString(paths)));
        }
        this.moduleDataProvider = new JarModuleDataProvider(this);
        this.filesystemRoot = this.newFileSystem(pathfilter, validPaths);
        this.filesystemPrimary = validPaths[validPaths.length - 1];
        this.manifest = this.findManifest(validPaths, defaultManifest);
        this.nameOverrides = this.gatherVersionedFiles();
        this.providers = this.gatherProviders(pathfilter);
        this.packages = this.gatherPackages();
        this.metadata = metadataFunction.apply(this);
    }

    @Override
    public CodeSigner[] getManifestSigners() {
        return this.getData("META-INF/MANIFEST.MF").map(r -> r.signers).orElse(null);
    }

    @Override
    public SecureJar.Status verifyPath(Path path) {
        if (path.getFileSystem() != this.filesystemRoot.getFileSystem()) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        String pathname = path.toString();
        if (this.statusData.containsKey(pathname)) {
            return this.getFileStatus(pathname);
        }
        try {
            byte[] bytes = Files.readAllBytes(path);
            this.verifyAndGetSigners(pathname, bytes);
            return this.getFileStatus(pathname);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public SecureJar.Status getFileStatus(String name) {
        return this.hasSecurityData() ? this.getData(name).map(StatusData::status).orElse(SecureJar.Status.NONE) : SecureJar.Status.UNVERIFIED;
    }

    @Override
    public Attributes getTrustedManifestEntries(String name) {
        Attributes manattrs = this.manifest.getAttributes(name);
        CodeSigner[] mansigners = this.getManifestSigners();
        CodeSigner[] objsigners = this.getData(name).map(sd -> sd.signers).orElse(EMPTY_CODESIGNERS);
        if (mansigners == null || mansigners.length == objsigners.length) {
            return manattrs;
        }
        return null;
    }

    @Override
    public boolean hasSecurityData() {
        return !this.pendingSigners.isEmpty() || !this.verifiedSigners.isEmpty();
    }

    @Override
    public String name() {
        return this.metadata.name();
    }

    @Override
    public Set<String> getPackages() {
        return this.packages;
    }

    @Override
    public List<SecureJar.Provider> getProviders() {
        return this.providers;
    }

    @Override
    public Path getPath(String first, String ... rest) {
        Path rel = this.filesystemRoot.getFileSystem().getPath(first, rest);
        return this.filesystemRoot.resolve(rel);
    }

    @Override
    public Path getRootPath() {
        return this.filesystemRoot;
    }

    public String toString() {
        return "Jar[" + this.getURI() + "]";
    }

    private Path newFileSystem(BiPredicate<String, String> filter, Path[] paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Must contain atleast one path");
        }
        FileSystem fs = null;
        try {
            if (filter == null && paths.length == 1) {
                if (Files.isDirectory(paths[0], new LinkOption[0])) {
                    return paths[0];
                }
                URI uri = paths[0].toUri();
                if ("file".equals(uri.getScheme())) {
                    uri = new URI("jar:" + uri);
                    try {
                        fs = FileSystems.newFileSystem(uri, Map.of(), null);
                    }
                    catch (FileSystemAlreadyExistsException e) {
                        fs = FileSystems.getFileSystem(uri);
                    }
                } else {
                    fs = UFSP.newFileSystem(paths[0], Map.of("filter", (a, b) -> true));
                }
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (filter != null) {
                    map.put("filter", filter);
                }
                ArrayList<Path> lst = new ArrayList<Path>(Arrays.asList(paths));
                Path base = lst.remove(0);
                map.put("additional", lst);
                fs = UFSP.newFileSystem(base, map);
            }
        }
        catch (IOException | URISyntaxException e) {
            return (Path)Jar.sneak(e);
        }
        return fs.getRootDirectories().iterator().next();
    }

    public synchronized CodeSigner[] verifyAndGetSigners(String name, byte[] bytes) {
        if (!this.hasSecurityData()) {
            return null;
        }
        StatusData data = this.statusData.get(name = this.nameOverrides.getOrDefault(name, name));
        if (data != null) {
            return data.signers();
        }
        Optional<CodeSigner[]> signers = this.verifier.verify(this.manifest, this.pendingSigners, this.verifiedSigners, name, bytes);
        if (signers == null) {
            this.statusData.put(name, new StatusData(SecureJar.Status.INVALID, null));
            return null;
        }
        CodeSigner[] ret = signers.orElse(null);
        this.statusData.put(name, new StatusData(SecureJar.Status.VERIFIED, ret));
        return ret;
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }

    private Optional<StatusData> getData(String name) {
        return Optional.ofNullable(this.statusData.get(name));
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public URI getURI() {
        return this.filesystemRoot.toUri();
    }

    public ModuleDescriptor computeDescriptor() {
        return this.metadata.descriptor();
    }

    public Optional<URI> findFile(String name) {
        Path resolved = this.filesystemRoot.resolve(name = this.nameOverrides.getOrDefault(name, name));
        if (Files.exists(resolved, new LinkOption[0])) {
            return Optional.of(resolved.toUri());
        }
        return Optional.empty();
    }

    private List<SecureJar.Provider> gatherProviders(BiPredicate<String, String> filter) {
        Path services = this.filesystemRoot.resolve("META-INF/services/");
        if (!Files.exists(services, new LinkOption[0])) {
            return List.of();
        }
        try {
            return Files.walk(services, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> Jar.getProvider(path, filter)).toList();
        }
        catch (IOException e) {
            return (List)Jar.sneak(e);
        }
    }

    public static SecureJar.Provider getProvider(Path path, BiPredicate<String, String> filter) {
        String sname = path.getFileName().toString();
        try {
            ArrayList<String> entries = new ArrayList<String>();
            for (String line : Files.readAllLines(path)) {
                int idx = line.indexOf(35);
                if (idx != -1) {
                    line = line.substring(0, idx);
                }
                if ((line = line.trim()).isEmpty() || filter != null && !filter.test(line.replace('.', '/'), "")) continue;
                entries.add(line);
            }
            return new SecureJar.Provider(sname, entries);
        }
        catch (IOException e) {
            return (SecureJar.Provider)Jar.sneak(e);
        }
    }

    private Map<String, String> gatherVersionedFiles() {
        Path versionsDir = this.filesystemRoot.resolve("META-INF/versions");
        if (!Boolean.parseBoolean(this.getManifest().getMainAttributes().getValue("Multi-Release")) || !Files.exists(versionsDir, new LinkOption[0])) {
            return Map.of();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        HashMap versions = new HashMap();
        try {
            Files.walk(versionsDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this.filesystemRoot::relativize).forEach(path -> {
                int ver = Integer.parseInt(path.getName(2).toString());
                String key = path.subpath(3, path.getNameCount()).toString().replace('\\', '/');
                if (ver <= Runtime.version().feature() && versions.getOrDefault(key, 0) < ver) {
                    versions.put(key, ver);
                    ret.put(key, path.toString());
                }
            });
        }
        catch (IOException e) {
            Jar.sneak(e);
        }
        return ret;
    }

    private Set<String> gatherPackages() {
        HashSet<String> files = new HashSet<String>(this.nameOverrides.keySet());
        try {
            Files.walk(this.filesystemRoot, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && !"META-INF".equals(p.getName(0).toString())).map(p -> this.filesystemRoot.relativize((Path)p).toString().replace('\\', '/')).forEach(files::add);
        }
        catch (IOException e) {
            return (Set)Jar.sneak(e);
        }
        HashSet<String> ret = new HashSet<String>();
        for (String file : files) {
            int idx = file.lastIndexOf(47);
            if (!file.endsWith(".class") || idx == -1) continue;
            ret.add(file.substring(0, idx).replace('/', '.'));
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest findManifest(Path[] paths, Supplier<Manifest> defaultManifest) {
        try {
            Manifest manifest;
            for (int x = paths.length - 1; x >= 0; --x) {
                Manifest manifest2;
                Path path = paths[x];
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Path manfile = path.resolve("META-INF/MANIFEST.MF");
                    if (!Files.exists(manfile, new LinkOption[0])) continue;
                    try (InputStream is = Files.newInputStream(manfile, new OpenOption[0]);){
                        manifest2 = new Manifest(is);
                        return manifest2;
                    }
                }
                try (JarInputStream jis = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    Object jv = SecureJarVerifier.getJarVerifier(jis);
                    if (jv != null) {
                        while (SecureJarVerifier.isParsingMeta(jv) && jis.getNextJarEntry() != null) {
                        }
                        if (SecureJarVerifier.hasSignatures(jv)) {
                            this.pendingSigners.putAll(SecureJarVerifier.getPendingSigners(jv));
                            CodeSigner[] manifestSigners = SecureJarVerifier.getVerifiedSigners(jv).get("META-INF/MANIFEST.MF");
                            if (manifestSigners != null) {
                                this.verifiedSigners.put("META-INF/MANIFEST.MF", manifestSigners);
                            }
                            this.statusData.put("META-INF/MANIFEST.MF", new StatusData(SecureJar.Status.VERIFIED, manifestSigners));
                        }
                    }
                    if (jis.getManifest() == null) continue;
                    manifest2 = new Manifest(jis.getManifest());
                    return manifest2;
                }
            }
            if (defaultManifest != null) {
                manifest = defaultManifest.get();
                return manifest;
            }
            manifest = new Manifest();
            return manifest;
        }
        catch (IOException e) {
            return (Manifest)Jar.sneak(e);
        }
    }

    private record JarModuleDataProvider(Jar jar) implements SecureJar.ModuleDataProvider
    {
        @Override
        public String name() {
            return this.jar.name();
        }

        @Override
        public ModuleDescriptor descriptor() {
            return this.jar.computeDescriptor();
        }

        @Override
        public URI uri() {
            return this.jar.getURI();
        }

        @Override
        public Optional<URI> findFile(String name) {
            return this.jar.findFile(name);
        }

        @Override
        public Optional<InputStream> open(String name) {
            Path resolved = this.jar.filesystemRoot.resolve(name = this.jar.nameOverrides.getOrDefault(name, name));
            if (Files.exists(resolved, new LinkOption[0])) {
                try {
                    return Optional.of(Files.newInputStream(resolved, new OpenOption[0]));
                }
                catch (IOException e) {
                    return (Optional)Jar.sneak(e);
                }
            }
            return Optional.empty();
        }

        @Override
        public Manifest getManifest() {
            return this.jar.getManifest();
        }

        @Override
        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return this.jar.verifyAndGetSigners(cname, bytes);
        }
    }

    private record StatusData(SecureJar.Status status, CodeSigner[] signers) {
    }
}

