/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex;

import java.io.Reader;
import java.io.Writer;
import java.util.Optional;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.MappingsReader;
import org.cadixdev.lorenz.io.MappingsWriter;
import org.cadixdev.lorenz.io.TextMappingFormat;
import org.cadixdev.lorenz.io.TextMappingsReader;
import org.cadixdev.lorenz.io.srg.SrgConstants;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.objectweb.asm.Type;

public class TSrg2Format
implements TextMappingFormat {
    @Override
    public MappingsReader createReader(Reader reader) {
        return new TSrg2Reader(reader);
    }

    @Override
    public MappingsWriter createWriter(Writer writer) {
        throw new UnsupportedOperationException("No writing TSRGv2");
    }

    @Override
    public Optional<String> getStandardFileExtension() {
        return Optional.empty();
    }

    public String toString() {
        return "tsrg2";
    }

    private static class TSrg2Reader
    extends TextMappingsReader {
        protected TSrg2Reader(Reader reader) {
            super(reader, Processor::new);
        }

        private static class Processor
        extends TextMappingsReader.Processor {
            private int nameCount = 0;
            private ClassMapping cls;
            private MethodMapping mtd;
            private int[] pidx;

            protected Processor(MappingSet mappings) {
                super(mappings);
            }

            @Override
            public void accept(String raw) {
                String line = SrgConstants.removeComments(raw);
                if (line.isEmpty()) {
                    return;
                }
                if (line.startsWith("tsrg2 ")) {
                    this.nameCount = line.split(" ").length - 1;
                    return;
                }
                String[] pts = line.split(" ");
                if (pts[0].charAt(0) != '\t') {
                    if (pts.length != this.nameCount) {
                        this.error(line);
                    }
                    if (pts[0].charAt(pts[0].length() - 1) != '/') {
                        this.cls = this.mappings.getOrCreateClassMapping(pts[0]);
                        this.cls.setDeobfuscatedName(pts[1]);
                    }
                } else if (pts[0].charAt(1) == '\t') {
                    if (this.mtd == null) {
                        this.error(line);
                    }
                    pts[0] = pts[0].substring(2);
                    if (pts.length == 1 && "static".equals(pts[0])) {
                        int x = 0;
                        while (x < this.pidx.length) {
                            int n = x++;
                            this.pidx[n] = this.pidx[n] - 1;
                        }
                    } else if (pts.length == this.nameCount + 1) {
                        this.mtd.getOrCreateParameterMapping(this.pidx[Integer.parseInt(pts[0])]).setDeobfuscatedName(pts[2]);
                    } else {
                        this.error(line);
                    }
                } else {
                    if (this.cls == null) {
                        this.error(line);
                    }
                    pts[0] = pts[0].substring(1);
                    if (pts.length == this.nameCount) {
                        this.cls.getOrCreateFieldMapping(pts[0]).setDeobfuscatedName(pts[1]);
                    } else if (pts.length == this.nameCount + 1) {
                        if (pts[1].charAt(0) == '(') {
                            this.mtd = (MethodMapping)this.cls.getOrCreateMethodMapping(pts[0], pts[1]).setDeobfuscatedName(pts[2]);
                            Type[] args = Type.getArgumentTypes(pts[1]);
                            this.pidx = new int[args.length];
                            int i = 1;
                            for (int x = 0; x < args.length; ++x) {
                                this.pidx[x] = i;
                                i += args[x].getSize();
                            }
                        } else {
                            this.mtd = null;
                            this.pidx = null;
                            this.cls.getOrCreateFieldMapping(pts[0], pts[1]).setDeobfuscatedName(pts[2]);
                        }
                    }
                }
            }

            private void error(String line) {
                throw new IllegalArgumentException("Failed to process line: `" + line + "`!");
            }
        }
    }
}

