/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex;

import java.util.Arrays;
import java.util.List;
import org.cadixdev.bombe.jar.JarClassEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ParameterAnnotationFixer
implements JarEntryTransformer {
    @Override
    public JarClassEntry transform(JarClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getContents());
        ClassWriter writer = new ClassWriter(reader, 0);
        ClassNode node = new ClassNode();
        reader.accept(new Visitor(node), 0);
        node.accept(writer);
        return new JarClassEntry(entry.getName(), entry.getTime(), writer.toByteArray());
    }

    private static class Visitor
    extends ClassVisitor {
        private final ClassNode node;

        public Visitor(ClassNode cn) {
            super(589824, cn);
            this.node = cn;
        }

        private void debug(String message) {
        }

        private void log(String message) {
            System.out.println(message);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            Type[] syntheticParams = this.getExpectedSyntheticParams(this.node);
            if (syntheticParams != null) {
                for (MethodNode mn : this.node.methods) {
                    if (!mn.name.equals("<init>")) continue;
                    this.processConstructor(this.node, mn, syntheticParams);
                }
            }
        }

        private Type[] getExpectedSyntheticParams(ClassNode cls) {
            if ((cls.access & 0x4000) != 0) {
                this.debug("  Considering " + cls.name + " for extra parameter annotations as it is an enum");
                return new Type[]{Type.getObjectType("java/lang/String"), Type.INT_TYPE};
            }
            InnerClassNode info = null;
            for (InnerClassNode node : cls.innerClasses) {
                if (!node.name.equals(cls.name)) continue;
                info = node;
                break;
            }
            if (info == null) {
                this.debug("  Not considering " + cls.name + " for extra parameter annotations as it is not an inner class");
                return null;
            }
            if ((info.access & 0x208) != 0) {
                this.debug("  Not considering " + cls.name + " for extra parameter annotations as is an interface or static");
                return null;
            }
            if (info.innerName == null) {
                this.debug("  Not considering " + cls.name + " for extra parameter annotations as it is annonymous");
                return null;
            }
            this.debug("  Considering " + cls.name + " for extra parameter annotations as it is an inner class of " + info.outerName);
            return new Type[]{Type.getObjectType(info.outerName)};
        }

        private void processConstructor(ClassNode cls, MethodNode mn, Type[] syntheticParams) {
            String methodInfo = mn.name + mn.desc + " in " + cls.name;
            Type[] params = Type.getArgumentTypes(mn.desc);
            if (this.beginsWith(params, syntheticParams)) {
                mn.visibleParameterAnnotations = this.process(methodInfo, "RuntimeVisibleParameterAnnotations", params.length, syntheticParams.length, mn.visibleParameterAnnotations);
                mn.invisibleParameterAnnotations = this.process(methodInfo, "RuntimeInvisibleParameterAnnotations", params.length, syntheticParams.length, mn.invisibleParameterAnnotations);
                if (mn.visibleParameterAnnotations != null) {
                    mn.visibleAnnotableParameterCount = mn.visibleParameterAnnotations.length;
                }
                if (mn.invisibleParameterAnnotations != null) {
                    mn.invisibleAnnotableParameterCount = mn.invisibleParameterAnnotations.length;
                }
            } else {
                this.log("Unexpected lack of synthetic args to the constructor: expected " + Arrays.toString(syntheticParams) + " at the start of " + methodInfo);
            }
        }

        private boolean beginsWith(Type[] values, Type[] prefix) {
            if (values.length < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (values[i].equals(prefix[i])) continue;
                return false;
            }
            return true;
        }

        private List<AnnotationNode>[] process(String methodInfo, String attributeName, int numParams, int numSynthetic, List<AnnotationNode>[] annotations) {
            if (annotations == null) {
                this.debug("    " + methodInfo + " does not have a " + attributeName + " attribute");
                return null;
            }
            int numAnnotations = annotations.length;
            if (numParams == numAnnotations) {
                this.log("Found extra " + attributeName + " entries in " + methodInfo + ": removing " + numSynthetic);
                return Arrays.copyOfRange(annotations, numSynthetic, numAnnotations);
            }
            if (numParams == numAnnotations - numSynthetic) {
                this.debug("Number of " + attributeName + " entries in " + methodInfo + " is already as we want");
                return annotations;
            }
            this.log("Unexpected number of " + attributeName + " entries in " + methodInfo + ": " + numAnnotations);
            return annotations;
        }
    }
}

