/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;

    private FMLServerHandler() {
        FMLCommonHandler.instance().beginLoading(this);
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods();
        Loader.instance().preinitializeMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public File getSavesDirectory() {
        return ((azg)this.server.W()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            FMLLog.warning("%s", query.getText());
            query.finish();
        } else {
            String text = query.getText() + "\n\nRun the command /fml confirm or or /fml cancel to proceed." + "\nAlternatively start the server with -Dfml.queryResult=confirm or -Dfml.queryResult=cancel to preselect the answer.";
            FMLLog.warning("%s", text);
            if (!query.isSynchronous()) {
                return;
            }
            boolean done = false;
            while (!done && this.server.w()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                lb dedServer = (lb)this.server;
                List list = dedServer.l;
                synchronized (list) {
                    Iterator<kq> it = GenericIterableFactory.newCastingIterable(dedServer.l, kq.class).iterator();
                    while (it.hasNext()) {
                        String cmd = it.next().a.trim().toLowerCase();
                        if (cmd.equals("/fml confirm")) {
                            FMLLog.info("confirmed", new Object[0]);
                            query.setResult(true);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (cmd.equals("/fml cancel")) {
                            FMLLog.info("cancelled", new Object[0]);
                            query.setResult(false);
                            done = true;
                            it.remove();
                            continue;
                        }
                        if (!cmd.equals("/stop")) continue;
                        StartupQuery.abort();
                    }
                }
                Thread.sleep(10L);
            }
            query.finish();
        }
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void addModAsResource(ModContainer container) {
        block21: {
            String langFile = "assets/" + container.getModId().toLowerCase() + "/lang/en_US.lang";
            File source = container.getSource();
            InputStream stream = null;
            ZipFile zip = null;
            if (source.isDirectory() && ((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                stream = new FileInputStream(new File(source.toURI().resolve(langFile).getPath()));
            } else {
                zip = new ZipFile(source);
                ZipEntry entry22222222222 = zip.getEntry(langFile);
                if (entry22222222222 == null) {
                    throw new FileNotFoundException();
                }
                stream = zip.getInputStream(entry22222222222);
            }
            dl.inject((InputStream)stream);
            IOUtils.closeQuietly((InputStream)stream);
            try {
                if (zip != null) {
                    zip.close();
                }
                break block21;
            }
            catch (IOException entry22222222222) {}
            break block21;
            catch (IOException entry22222222222) {
                IOUtils.closeQuietly(stream);
                try {
                    if (zip != null) {
                        zip.close();
                    }
                    break block21;
                }
                catch (IOException entry22222222222) {}
                break block21;
            }
            catch (Exception e2) {
                FMLLog.getLogger().error((Object)e2);
                break block21;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(stream);
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getCurrentLanguage() {
        return "en_US";
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public em getClientToServerNetworkManager() {
        throw new RuntimeException("Missing");
    }

    @Override
    public er getClientPlayHandler() {
        return null;
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, em manager, Set<String> channelSet, String channel, Side side) {
        bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<mc>(manager, channelSet, channel, side, mc.class));
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return lb.allowPlayerLogins;
    }

    @Override
    public void allowLogins() {
        lb.allowPlayerLogins = true;
    }

    @Override
    public qc getWorldThread(er net) {
        return this.getServer();
    }

    @Override
    public void processWindowMessages() {
    }

    @Override
    public String stripSpecialChars(String message) {
        return message;
    }
}

