/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import org.apache.commons.lang3.Validate;

public class VillagerRegistry {
    public static final kl PROFESSIONS = new kl("minecraft:villagerprofessions");
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private boolean hasInit = false;
    private FMLControlledNamespacedRegistry<VillagerProfession> professions = PersistentRegistryManager.createRegistry(PROFESSIONS, VillagerProfession.class, null, 0, 1024, true, null, null, null);

    private VillagerRegistry() {
        this.init();
    }

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public static void addExtraVillageComponents(List<awk.e> list, Random random, int i) {
        List<awk.e> parts = list;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static awk.n getVillageComponent(awk.e villagePiece, awk.k startPiece, List<awg> pieces, Random random, int p1, int p2, int p3, cs facing, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    public void register(VillagerProfession prof) {
        this.register(prof, -1);
    }

    private void register(VillagerProfession prof, int id) {
        this.professions.register(id, prof.name, prof);
    }

    public IForgeRegistry<VillagerProfession> getRegistry() {
        return this.professions;
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        VillagerProfession prof = new VillagerProfession("minecraft:farmer", "minecraft:textures/entity/villager/farmer.png");
        this.register(prof, 0);
        new VillagerCareer(prof, "farmer").init(VanillaTrades.trades[0][0]);
        new VillagerCareer(prof, "fisherman").init(VanillaTrades.trades[0][1]);
        new VillagerCareer(prof, "shepherd").init(VanillaTrades.trades[0][2]);
        new VillagerCareer(prof, "fletcher").init(VanillaTrades.trades[0][3]);
        prof = new VillagerProfession("minecraft:librarian", "minecraft:textures/entity/villager/librarian.png");
        this.register(prof, 1);
        new VillagerCareer(prof, "librarian").init(VanillaTrades.trades[1][0]);
        prof = new VillagerProfession("minecraft:priest", "minecraft:textures/entity/villager/priest.png");
        this.register(prof, 2);
        new VillagerCareer(prof, "cleric").init(VanillaTrades.trades[2][0]);
        prof = new VillagerProfession("minecraft:smith", "minecraft:textures/entity/villager/smith.png");
        this.register(prof, 3);
        new VillagerCareer(prof, "armor").init(VanillaTrades.trades[3][0]);
        new VillagerCareer(prof, "weapon").init(VanillaTrades.trades[3][1]);
        new VillagerCareer(prof, "tool").init(VanillaTrades.trades[3][2]);
        prof = new VillagerProfession("minecraft:butcher", "minecraft:textures/entity/villager/butcher.png");
        this.register(prof, 4);
        new VillagerCareer(prof, "butcher").init(VanillaTrades.trades[4][0]);
        new VillagerCareer(prof, "leather").init(VanillaTrades.trades[4][1]);
    }

    public static void setRandomProfession(ze entity, Random rand) {
        Set entries = VillagerRegistry.INSTANCE.professions.c();
        entity.l(rand.nextInt(entries.size()));
    }

    public static void onSetProfession(ze entity, VillagerProfession prof) {
        int network = VillagerRegistry.INSTANCE.professions.getId(prof);
        if (network == -1 || prof != VillagerRegistry.INSTANCE.professions.getObjectById(network)) {
            throw new RuntimeException("Attempted to set villager profession to unregistered profession: " + network + " " + prof);
        }
        if (network != entity.da()) {
            entity.l(network);
        }
    }

    public static void onSetProfession(ze entity, int network) {
        VillagerProfession prof = VillagerRegistry.INSTANCE.professions.getObjectById(network);
        if (prof == null || VillagerRegistry.INSTANCE.professions.getId(prof) != network) {
            throw new RuntimeException("Attempted to set villager profession to unregistered profession: " + network + " " + prof);
        }
        if (prof != entity.getProfessionForge()) {
            entity.setProfession(prof);
        }
    }

    private static class VanillaTrades {
        private static final ze.f[][][][] trades = ze.GET_TRADES_DONT_USE();

        private VanillaTrades() {
        }
    }

    public static class VillagerCareer {
        private VillagerProfession profession;
        private String name;
        private int id;
        private List<List<ze.f>> trades = Lists.newArrayList();

        public VillagerCareer(VillagerProfession parent, String name) {
            this.profession = parent;
            this.name = name;
            parent.register(this);
        }

        public String getName() {
            return this.name;
        }

        public VillagerCareer addTrade(int level, ze.f ... trades) {
            ArrayList levelTrades;
            if (level <= 0) {
                throw new IllegalArgumentException("Levels start at 1");
            }
            ArrayList arrayList = levelTrades = level <= this.trades.size() ? this.trades.get(level - 1) : null;
            if (levelTrades == null) {
                while (this.trades.size() < level) {
                    levelTrades = Lists.newArrayList();
                    this.trades.add(levelTrades);
                }
            }
            if (levelTrades == null) {
                levelTrades = Lists.newArrayList();
                this.trades.set(level - 1, levelTrades);
            }
            for (ze.f t : trades) {
                levelTrades.add(t);
            }
            return this;
        }

        public List<ze.f> getTrades(int level) {
            return level >= 0 && level < this.trades.size() ? Collections.unmodifiableList(this.trades.get(level)) : null;
        }

        private VillagerCareer init(ze.f[][] trades) {
            for (int x = 0; x < trades.length; ++x) {
                this.trades.add(Lists.newArrayList((Object[])trades[x]));
            }
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VillagerCareer)) {
                return false;
            }
            VillagerCareer oc = (VillagerCareer)o;
            return this.name.equals(oc.name) && this.profession == oc.profession;
        }
    }

    public static class VillagerProfession
    extends IForgeRegistryEntry.Impl<VillagerProfession> {
        private kl name;
        private kl texture;
        private List<VillagerCareer> careers = Lists.newArrayList();

        public VillagerProfession(String name, String texture) {
            this.name = new kl(name);
            this.texture = new kl(texture);
            this.setRegistryName(this.name);
        }

        private void register(VillagerCareer career) {
            Validate.isTrue((!this.careers.contains(career) ? 1 : 0) != 0, (String)"Attempted to register career that is already registered.", (Object[])new Object[0]);
            Validate.isTrue((career.profession == this ? 1 : 0) != 0, (String)"Attempted to register career for the wrong profession.", (Object[])new Object[0]);
            career.id = this.careers.size();
            this.careers.add(career);
        }

        public kl getSkin() {
            return this.texture;
        }

        public VillagerCareer getCareer(int id) {
            for (VillagerCareer car : this.careers) {
                if (car.id != id) continue;
                return car;
            }
            return this.careers.get(0);
        }

        public int getRandomCareer(Random rand) {
            return this.careers.get(rand.nextInt(this.careers.size())).id;
        }
    }

    public static interface IVillageCreationHandler {
        public awk.e getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public awk.n buildComponent(awk.e var1, awk.k var2, List<awg> var3, Random var4, int var5, int var6, int var7, cs var8, int var9);
    }
}

